<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\App\V1;
use App\Http\Controllers\App\V1\Auth;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::prefix('v1')->group(function () {
    // Route::middleware(['verify.hmac'])->group(function () {

        Route::get('settings', [V1\IndexController::class, 'settings']);
        Route::get('pages', [V1\IndexController::class, 'pages']);
        Route::post('contact-us', [V1\IndexController::class, 'contactUs']);

        Route::post('login', [Auth\LoginController::class, 'login']);
        Route::post('register', [Auth\RegisterController::class, 'register']);

        Route::post('forgot-password', [Auth\ForgotPasswordController::class, 'forgotPassword']);
        Route::post('reset-password', [Auth\ForgotPasswordController::class, 'resetPassword']);

        Route::post('resend-phone-verification-code', [Auth\VerificationController::class, 'resendPhoneVerificationCode']);
        Route::post('verify-phone', [Auth\VerificationController::class, 'verifyPhone']);

        Route::middleware(['auth:sanctum'])->group(function () {
            
            Route::get('notifications', [V1\NotificationController::class, 'notifications']);
            Route::get('read-all-notification', [V1\NotificationController::class, 'readAll']);
            Route::get('mark-as-read/{id}', [V1\NotificationController::class, 'markAsRead']);

            Route::post('resend-email-verification-code', [Auth\VerificationController::class, 'resendEmailVerificationCode']);
            
            Route::post('verify-email', [Auth\VerificationController::class, 'verifyEmail']);

            Route::post('update-account', [V1\UserController::class, 'updateAccount']);
            Route::post('update-password', [Auth\ForgotPasswordController::class, 'updatePassword']);
            Route::delete('delete-account', [V1\UserController::class, 'deleteAccount']);
            Route::post('logout', [Auth\LoginController::class, 'logout']);
        });
    // });
});
Route::prefix('v2')->group(function () {
    
});