<div>
    <section class="hero-wrap hero-wrap-2" style="background-image: url({{asset('storage/rooms/room.png')}});">
        <div class="overlay"></div>
        <div class="container">
            <div class="row no-gutters slider-text align-items-center justify-content-center">
                <div class="col-md-9 pt-5 text-center">
                    <p class="breadcrumbs">
                        <span class="me-2">
                            <a href="{{ route('/') }}">{{ __("web.Home") }} <i class="bi bi-chevron-right"></i></a>
                        </span>
                        <span>{{ __("web.Rooms") }} <i class="bi bi-chevron-right"></i></span>
                    </p>
                    <h1 class="mb-0 bread">{{ __("web.Luxury Rooms") }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="ftco-section">
        <div class="container-xl">
            <div class="row row-cols-1 row-cols-lg-3 g-2 g-lg-3 justify-content-center">
                @if ($rooms->count()) @foreach($rooms as $room)
                <div class="col d-flex align-items-stretch aos-init" data-aos="flip-left" data-aos-delay="100" data-aos-duration="1000">
                    <div class="room-wrap {{ $loop->iteration % 2 == 0 ? 'd-md-flex flex-md-column-reverse' :'' }}">
                        @if ($room->photos->count())
                        <div id="carouselExampleAutoplaying-{{ $loop->iteration }}" class="carousel slide" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                @foreach($room->photos as $key => $photo)
                                <div class="carousel-item @if($key == 0) active @endif">
                                    <a href="{{ route('room-detail',$room->slug) }}" aria-label="{{ $room->translation()->name }}">
                                        <img src="{{ asset( $photo->photo) }}" class="d-block w-100" alt="" />
                                    </a>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endif
                        <div class="text p-5 pb-4 text-center">
                            <p class="fs-3 mb-0 text-uppercase"><a href="{{ route('room-detail',$room->slug) }}">{{ $room->translation()->name }}</a></p>
                            <p>{{ $room->translation()->short_description }}</p>
                            <p class="mt-5 text-uppercase price">{{ __("web.Starting From") }}</p>
                            <p class="d-flex mb-0 justify-content-between align-items-center">
                                <span class="price text-uppercase">{{ $room->price }} <small>/ {{ __("web.night") }}</small></span>
                                <a href="https://www.booking.com/hotel/qa/imperial-suites.html" target="_blank" class="btn-custom text-nowrap">{{ __("web.Book Now") }}</a>
                            </p>
                        </div>
                    </div>
                </div>
                @endforeach @endif
            </div>
        </div>
    </section>

    <section class="ftco-section">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                    <span class="subheading">{{ __("web.Imperail Services") }}</span>
                    <h2 class="mb-4">{{ __("web.Explore Our Hotel Services") }}</h2>
                </div>
            </div>
            <div class="row row-cols-2 row-cols-lg-6 g-2 g-lg-3 justify-content-center mb-5">
                @if($services->count()) @foreach ($services as $service)
                <div class="col text-center d-flex align-items-stretch aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                    <a href="#" class="services">
                        <div class="icon">
                            <img src="{{ asset($service->image) }}" class="img-fluid" alt="" />
                        </div>
                        <div class="text">
                            <h2>{{ $service->translation()->name }}</h2>
                        </div>
                    </a>
                </div>
                @endforeach @endif
            </div>
            <div class="row justify-content-center mb-5">
                <div class="col-md-12 text-center">
                    <p class="mb-0"><a href="{{ route('services') }}" class="btn btn-primary py-md-4 py-3 px-md-5 px-4">{{ __("web.View More") }}</a></p>
                </div>
            </div>
        </div>
    </section>
</div>
