<div>
    <section class="hero-wrap hero-wrap-2" style="background-image: url({{asset('storage/rooms/room.png')}});">
        <div class="overlay"></div>
        <div class="container">
            <div class="row no-gutters slider-text align-items-center justify-content-center">
                <div class="col-md-9 pt-5 text-center">
                    <p class="breadcrumbs">
                        <span class="me-2">
                            <a href="{{ route('/') }}">{{ __("web.Home") }} <i class="fa fa-chevron-right"></i></a>
                        </span>
                        <span>{{ __("web.Rooms") }} <i class="fa fa-chevron-right"></i></span>
                    </p>
                    <h1 class="mb-0 bread">{{ $room->name }}</h1>
                </div>
            </div>
        </div>
    </section>
    <section class="ftco-section ftco-about-section">
        <div class="container-xl">
            <div class="row g-xl-5">
                <div class="col-md-7 aos-init" data-aos="fade-up" data-aos-delay="1000" data-aos-duration="1000">
                    <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            @if ($room->photos->count()) @foreach($room->photos as $key => $photo)
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="{{ $key }}" class="@if($key==0) active @endif" aria-label="{{ $key }}"></button>
                            @endforeach @endif
                        </div>
                        <div class="carousel-inner">
                            @if ($room->photos->count()) @foreach($room->photos as $key => $photo)
                            <div class="carousel-item @if($key==0) active @endif">
                                <img src="{{ asset($photo->photo) }}" class="d-block w-100" alt="..." />
                            </div>
                            @endforeach @endif
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev" aria-label="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden"></span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next" aria-label="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden"></span>
                        </button>
                    </div>
                </div>
                <div class="col-md-5 heading-section d-flex aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <div class="mt-5 mt-md-0">
                        <h2 class="mb-4" style="font-size: 40px;">{{ $room->translation()->name }}</h2>
                        <p class="mb-3">{{ $room->translation()->short_description }}</p>
                        <div class="row">
                            <div class="col-lg-4">
                                <p class="fs-3 mb-2">{{ __("web.Space") }}</p>
                                <div class="ftco-footer-widget mb-2">
                                    <ul class="list-unstyled">
                                        <li><a href="#">{{ $room->space }}</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <p class="fs-3 mb-2">{{ __("web.Capacity") }}</p>
                                <div class="ftco-footer-widget mb-2">
                                    <ul class="list-unstyled">
                                        <li><a href="#">{{ $room->translation()->capacity }}</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <p class="fs-3">{{ __("web.Starting From") }}</p>
                        <span class="subheading">{{ __("web.QAR") }} {{ $room->price }} {{ __("web.per night") }}</span>
                        <p><a href="https://www.booking.com/hotel/qa/imperial-suites.html" class="btn btn-primary text-nowrap py-3 px-4 mt-2">{{ __("web.Book Your Room Now")}}</a></p>
                    </div>
                </div>
            </div>

            <div class="row g-xl-5 mb-3">
                <div class="col-lg-12 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <p class="mb-4 mt-5">{{ __("web.Description") }}</p>
                    <div class="ftco-footer-widget mb-4">
                        <p><?=stripslashes($room->translation()->description) ?></p>
                    </div>
                </div>
            </div>
            <div class="row g-xl-5">
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <p class="fs-3 mb-2">{{ __("web.Services") }}</p>
                    <div class="ftco-footer-widget mb-4">
                        <ul class="list-unstyled">
                            @if(!empty($room->services)) @foreach ($room->services as $service)
                            <li><a href="#">{{ $service->translation()->name }}</a></li>
                            @endforeach @endif
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <h3 class="mb-2">{{ __("web.Facilities") }}</h3>
                    <div class="ftco-footer-widget mb-4">
                        <ul class="list-unstyled">
                            @if(!empty($room->facilities)) @foreach ($room->facilities as $facility)
                            <li><a href="#">{{ $facility->translation()->name }}</a></li>
                            @endforeach @endif
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <p class="fs-3 mb-2">{{ __("web.Privileges") }}</p>
                    <div class="ftco-footer-widget mb-4">
                        <ul class="list-unstyled">
                            @if(!empty($room->privileges)) @foreach ($room->privileges as $privilege)
                            <li><a href="#">{{ $privilege->translation()->name }}</a></li>
                            @endforeach @endif
                        </ul>
                    </div>
                </div>
            </div>
            <p class="fs-3 mb-2">{{ __("web.Amenities") }}</p>
            <div class="row g-xl-5 mb-3">
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <div class="amenities-span ftco-footer-widget mb-4">
                        <p class="fs-5">{{ __("web.Bedroom") }}</p>
                        <div class="ftco-footer-widget mb-4">
                            <ul class="list-unstyled">
                                @foreach (__('web.bedroomFeatures') as $key => $feature)
                                 @if($room->slug != 'two-bedroom-apartment' && $key == '1 / 2 Single Beds')
                                    @continue
                                 @endif
                                 <li>{{ $feature }}</li>
                              @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <div class="amenities-span ftco-footer-widget mb-4">
                        <p class="fs-5">{{ __("web.Living Area") }}</p>
                        <div class="ftco-footer-widget mb-4">
                            <ul class="list-unstyled">
                              @foreach (__('web.livingAreaFeatures') as $key => $feature)
                                 <li>{{ $feature }}</li>
                              @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <div class="amenities-span ftco-footer-widget mb-4">
                        <p class="fs-5">{{ __("web.Bathroom") }}</p>
                        <div class="ftco-footer-widget mb-4">
                            <ul class="list-unstyled">
                                @foreach (__('web.bathroomFeatures') as $key => $feature)
                                 <li>{{ $feature }}</li>
                              @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                    <div class="amenities-span ftco-footer-widget mb-4">
                        <p class="fs-5">{{ __("web.Kitchen") }}</p>
                        <div class="ftco-footer-widget mb-4">
                            <ul class="list-unstyled">
                                @foreach (__('web.kitchenFeatures') as $key => $feature)
                                 <li>{{ $feature }}</li>
                              @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
