<div>
    <style>
        .glo-service {
            background-color: #ffffff;
            box-shadow: 0 0 5px 2px rgba(0, 0, 0, 0.05);
        }
        .img-hover.overlay::before {
            height: 100%;
            width: 100%;
            content: "";
            background: var(--clr-theme-7);
            position: absolute;
            top: 0;
            left: 0;
            opacity: 0;
            visibility: hidden;
            z-index: 1;
            transform: translate(100%, 100%);
            transition: opacity 400ms ease, visibility 400ms ease, transform 600ms ease, -webkit-transform 600ms ease;
        }
        .glo-service-thumb .img-hover {
            display: block;
        }
        .img-hover.overlay {
            position: relative;
            overflow: hidden;
        }
        .glo-service-title {
            letter-spacing: 1px;
            font-size: 30px;
        }
    </style>
    <section class="ftco-section">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                    <span class="subheading">{{ __("web.Nearby Places to visit")}}</span>
                    <h2 class="mb-4">{{ __("web.Attraction near Imperial")}}</h2>
                </div>
            </div>
            <section class="glo-service-area pt-120 pb-80">
                <div class="row">
                    @if($places->count()) @foreach($places as $place)
                    <div class="col-12 mb-4 aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                        <div
                            class="glo-service wow fadeInUp"
                            data-wow-duration="1s"
                            data-wow-delay=".3s"
                            data-background="{{asset('storage/places/pattern.png')}}"
                            style="background-image: url({{asset('storage/places/pattern.png')}}); visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: fadeInUp;background-color: #fff;"
                        >
                            <div class="row g-0 align-items-center">
                                <div class="col-xl-5 col-12">
                                    <a href="#">
                                        <div class="glo-service-thumb">
                                            <div class="img-hover overlay">
                                                <img src="{{asset($place->image)}}" class="img-fluid" alt="Image not found" />
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-xl-7 col-12">
                                    <div class="p-4 p-md-5">
                                        <h3 class="glo-service-title text-capitalize">{{ $place->translation()->name }}</h3>
                                        <p><?=stripslashes($place->translation()->description)?></p>
                                        @if(!empty($place))
                                        <a href="{{ $place->url }}" target="_blank" class="btn btn-primary py-md-3 py-2 mt-3 px-md-5 px-4">{{ __("web.Checkout")}}</a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach @endif
                </div>
            </section>
        </div>
    </section>
</div>
