<div>
    <section class="ftco-section">
        <div class="container">
            <div class="row no-gutters justify-content-center">
                <div class="col-md-12">
                    @if(Session::has('message'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ Session::get('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="wrapper">
                        <div class="row g-3">
                            <div class="col-lg-6">
                                <div class="contact-wrap w-100 p-md-5 p-4">
                                    <h3>{{ __("web.WE`D LOVE TO HEAR FROM YOU!") }}</h3>
                                    <p>{{ __("web.Your feedback is important to us, and we value the opportunity to address any questions or concerns you may have. Please feel free to contact us we are here to assist you and appreciate your engagement with our organization.") }}</p>
                                    <div class="row mb-4">
                                        <div class="col-md-12 mb-3">
                                            <div class="dbox w-100 d-flex align-items-start">
                                                <div class="text">
                                                    <p><span>{{ __("web.Address") }}:</span> {{ Request::get('settings')[14]->value }}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="dbox w-100 d-flex align-items-start">
                                                <div class="text">
                                                    <p><span>{{ __("web.Email") }}:</span> <a href="mailto:{{ Request::get('settings')[4]->value }}">{{ Request::get('settings')[4]->value }}</a></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="dbox w-100 d-flex align-items-start">
                                                <div class="text">
                                                    <p><span>{{ __("web.Phone") }}:</span> <a href="tel:{{ Request::get('settings')[6]->value }}" dir="ltr">{{ Request::get('settings')[6]->value }}</a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <form wire:submit="contact" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                                        <div class="row g-1">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="text" class="form-control @error('name') is-invalid @enderror" wire:model="name" value="{{ old('name') }}" placeholder="{{ __("web.Name") }}" />
                                                    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="email" class="form-control @error('email') is-invalid @enderror" wire:model="email" value="{{ old('email') }}" placeholder="{{ __("web.Email") }}" />
                                                    @error('email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="text" class="form-control @error('subject') is-invalid @enderror" wire:model="subject" value="{{ old('subject') }}" placeholder="{{ __("web.Subject") }}" />
                                                    @error('subject')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <textarea wire:model="message" class="form-control @error('message') is-invalid @enderror" cols="30" rows="4" placeholder="{{ __("web.Write your message here...") }}">{{ old('message') }}</textarea>
                                                    @error('message')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                             <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                                <span wire:loading wire:target="contact" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                               {{ __('web.Send Message')}}
                                             </button>
                                                
                                            </div>
                                        </div>
                                    </form>
                                    <div class="w-100 social-media mt-5">
                                        <h3>{{ __("web.Follow us here") }}</h3>
                                        <ul class="ftco-footer-social list-unstyled mt-2">
                                            <li>
                                                <a href="{{ Request::get('settings')[26]->value }}" target="_blank" aria-label="facebook"><span class="bi bi-facebook"></span></a>
                                            </li>
                                            <li>
                                                <a href="{{ Request::get('settings')[27]->value }}" target="_blank" aria-label="instagram"><span class="bi bi-instagram"></span></a>
                                            </li>
                                            <li>
                                                <a href="{{ Request::get('settings')[25]->value }}" target="_blank" aria-label="tiktok"><span class="bi bi-tiktok"></span></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 d-flex align-items-stretch">
                                <iframe src="{{ Request::get('settings')[17]->value }}" style="height: 100%; width: 100%;" title="map" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
