<div>
   <button wire:click="create" class="btn btn-primary btn-sm py-3 position-fixed end-0 d-flex" style="bottom: 300px;writing-mode: vertical-rl;z-index:1;" type="button">{{ __("web.Give Feedback") }}</button>
   @if($createModal)
   <div class="offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="createModal" aria-labelledby="createModalLabel" wire:ignore.self>
      <div class="offcanvas-header">
         <h5 class="offcanvas-title" id="createModalLabel">
            <img src="{{ asset(Request::get('settings')[2]->value) }}" width="80" class="img-fluid" alt="">
         </h5>
         <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close" wire:click="$dispatch('createModal')"></button>
      </div>
      <div class="offcanvas-body">
         <form wire:submit="feedback" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
            <div class="row row row-cols-1 g-3 g-lg-3">
               <div class="col">
                  <p class="form-label mb-2">{{ __("web.How would you rate this page ?") }}</p>
                  <div class="emojis">
                     <input type="radio" class="btn-check" wire:model="rating" value="1" id="option1" autocomplete="off">
                     <label class="btn btn-sm btn-outline-secondary rounded-circle" for="option1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Very Dissatisfied"><i class="fs-5 bi bi-emoji-angry"></i></label>
         
                     <input type="radio" class="btn-check" wire:model="rating" value="2" id="option2" autocomplete="off">
                     <label class="btn btn-sm btn-outline-secondary rounded-circle" for="option2"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Dissatisfied"><i class="fs-5 bi bi-emoji-astonished"></i></label>
         
                     <input type="radio" class="btn-check" wire:model="rating" value="3" id="option3" autocomplete="off">
                     <label class="btn btn-sm btn-outline-secondary rounded-circle" for="option3"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Neutral"><i class="fs-5 bi bi-emoji-neutral"></i></label>
         
                     <input type="radio" class="btn-check" wire:model="rating" value="4" id="option4" autocomplete="off">
                     <label class="btn btn-sm btn-outline-secondary rounded-circle" for="option4"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Satisfied"><i class="fs-5 bi bi-emoji-smile"></i></label>

                     <input type="radio" class="btn-check" wire:model="rating" value="5" id="option5" autocomplete="off">
                     <label class="btn btn-sm btn-outline-secondary rounded-circle" for="option5"  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Very Satisfied"><i class="fs-5 bi bi-emoji-heart-eyes"></i></label>
                  </div>
                 <x-input-error :messages="$errors->get('rating')"/>
               </div>
               <div class="col">
                  <label for="subject" class="form-label mb-0">{{ __("web.Please select a subject") }}</label>
                  <div class="form-group">
                     <select wire:model="subject" id="subject" class="form-control @error('subject') is-invalid @enderror" aria-labelledby="subject" aria-required="true">
                        <option value="">{{ __("web.Choose a subject") }}</option>
                        <option value="all_good">{{ __("web.All Good") }}</option>
                        <option value="enhancement">{{ __("web.Something to improve") }}</option>
                        <option value="tech_issue">{{ __("web.Technical issue") }} </option>
                        <option value="loading_time">{{ __("web.Loading time") }}</option>
                     </select>
                     @error('subject')<div class="invalid-feedback">{{ $message }}</div>@enderror
                  </div>
               </div>
               <div class="col">
                  <div class="form-group">
                     <label for="message" class="form-label mb-0">{{ __("web.Your Message") }}</label>
                     <textarea wire:model="message" class="form-control @error('message') is-invalid @enderror" id="message" cols="30" rows="3" placeholder="{{ __('web.Write your message here...') }}"></textarea>
                     @error('message')<div class="invalid-feedback">{{ $message }}</div>@enderror
                  </div>
               </div>
               <div class="col">
                  <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                     <span wire:loading wire:target="feedback" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                     {{ __('web.Send')}}
                  </button>
               </div>
            </div>
         </form>
      </div>
   </div>
   @endif
   <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
@script
    <script>
        $wire.on('showModal', (event) => {
            setTimeout(function () {
                const modal = new bootstrap.Offcanvas(document.getElementById(event[0].modal));
                modal.show();
            },0);
        });
        $wire.on('hideModal', (event) => {
            setTimeout(function () {
                const modalElement = document.getElementById(event[0].modal);
                const modal = bootstrap.Offcanvas.getInstance(modalElement);
                modal.hide();
                Livewire.dispatch(event[0].modal);
            },0);
        });
    </script>
@endscript