@props(['on'])
<div
    x-data="{ show: '',timeout: null ,type: '', message: ''}"
    x-init="@this.on('{{ $on }}', (event) => {
            clearTimeout(timeout); 
            type = event[0].type;
            message = event[0].message;
            show = 'fade show';
            timeout = setTimeout(() => { show = '' }, 2000);
        })"
    class="toast-container position-fixed top-0 end-0 mt-5 p-3">
    <div class="toast" :class="`text-bg-${type} ${show}`"  data-bs-autohide="false" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
        <div class="d-flex">
            <div class="toast-body" x-text="message"></div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>
