@if ($paginator->hasPages())
<div></div>
<div class="py-1 px-2 mt-0 row row-cols-1 row-cols-md-2 g-2 g-lg-2">
    <div class="col my-auto">
        <div class="py-2 d-flex">
            <nav class="my-auto me-auto" style="--bs-breadcrumb-divider: '';" aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item">From</li>
                    <li class="breadcrumb-item active" aria-current="page">{{$paginator->firstItem()}}</li>
                    <li class="breadcrumb-item ps-0" aria-current="page">to</li>
                    <li class="breadcrumb-item ps-0 active" aria-current="page">{{$paginator->lastItem()}}</li>
                    <li class="breadcrumb-item ps-0" aria-current="page">total of</li>
                    <li class="breadcrumb-item ps-0 active" aria-current="page">{{$paginator->total()}}</li>
                </ol>
            </nav>
        </div>
    </div>
    <div class="col my-auto">
        <div class="d-flex justify-content-end align-items-center">
            <label class="control-label my-auto me-2" for="perPage">
                <select wire:model.live.debounce.300ms="perPage" class="p-1 rounded input-sm" id="perPage" style="background-color: var(--bs-body-bg);">
                    <option value="10" {{ $this->perPage == 10 ? 'selected' : '' }} >10</option>
                    <option value="20" {{ $this->perPage == 20 ? 'selected' : '' }}>20</option>
                    <option value="50" {{ $this->perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $this->perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="500" {{ $this->perPage == 500 ? 'selected' : '' }}>500</option>
                </select>
            </label>
            <nav aria-label="Page navigation">
                <ul class="pagination pagination-sm mb-0">
                    @if ($paginator->onFirstPage())
                    <li class="page-item disabled"><span class="page-link py-1 px-2">&laquo;</span></li>
                    @else
                    <li class="page-item" wire:click="previousPage" wire:loading.attr="disabled">
                        <a class="page-link" href="javascript:void(0);" aria-label="Previous"><span aria-hidden="true">&laquo;</span></a>
                    </li>
                    @endif {{-- Pagination Elements --}} @foreach ($elements as $element) {{-- "Three Dots" Separator --}} @if (is_string($element))
                    <li class="page-item disabled"><span>{{ $element }}</span></li>
                    @endif {{-- Array Of Links --}} @if (is_array($element)) @foreach ($element as $page => $url) @if ($page == $paginator->currentPage())
                    <li class="page-item active"><span class="page-link py-1 px-2">{{ $page }}</span></li>
                    @else
                    <li class="page-item" wire:click="gotoPage({{ $page }})"><a class="page-link py-1 px-2" href="javascript:void(0);">{{ $page }}</a></li>
                    @endif @endforeach @endif @endforeach {{-- Next Page Link --}} @if ($paginator->hasMorePages())
                    <li class="page-item" wire:click="nextPage" wire:loading.attr="disabled">
                        <a class="page-link" href="javascript:void(0);" aria-label="Next"><span aria-hidden="true">&raquo; </span></a>
                    </li>
                    @else
                    <li class="page-item disabled"><span class="page-link py-1 px-2">&raquo;</span></li>
                    @endif
                </ul>
            </nav>
        </div>
    </div>
</div>
@endif