<div>
  <!-- ======= Header ======= -->
  <header id="header" class="header px-2 fixed-top d-flex align-items-center">
    <div class="d-flex align-items-center justify-content-between">
      <svg @click="sidebar = sidebar === 'toggle-sidebar' ? '' : 'toggle-sidebar'; localStorage.setItem('sidebar', sidebar)" xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-list pointer-cursor" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5"/>
      </svg>
      <a href="{{ route('dashboard') }}" wire:navigate class="logo ms-2 d-flex align-items-center">
        <img src="{{ asset(Request::get('settings')[3]->value) }}" alt="...">
        <span class="d-none d-lg-block fs-6 fw-medium" x-data="{{ json_encode(['app_name' => Request::get('settings')[0]->value]) }}" x-text="app_name" x-on:app_name.window="app_name = $event.detail.app_name">{{ Request::get('settings')[0]->value }}</span>
      </a>
     
    </div><!-- End Logo -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">
        <li class="nav-item dropdown mx-1 d-none d-md-block d-lg-block" onclick="fullscreen();">
            <a class="nav-link w-auto position-relative text-center p-2" href="javascript:void(0);">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-arrows-fullscreen" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M5.828 10.172a.5.5 0 0 0-.707 0l-4.096 4.096V11.5a.5.5 0 0 0-1 0v3.975a.5.5 0 0 0 .5.5H4.5a.5.5 0 0 0 0-1H1.732l4.096-4.096a.5.5 0 0 0 0-.707m4.344 0a.5.5 0 0 1 .707 0l4.096 4.096V11.5a.5.5 0 1 1 1 0v3.975a.5.5 0 0 1-.5.5H11.5a.5.5 0 0 1 0-1h2.768l-4.096-4.096a.5.5 0 0 1 0-.707m0-4.344a.5.5 0 0 0 .707 0l4.096-4.096V4.5a.5.5 0 1 0 1 0V.525a.5.5 0 0 0-.5-.5H11.5a.5.5 0 0 0 0 1h2.768l-4.096 4.096a.5.5 0 0 0 0 .707m-4.344 0a.5.5 0 0 1-.707 0L1.025 1.732V4.5a.5.5 0 0 1-1 0V.525a.5.5 0 0 1 .5-.5H4.5a.5.5 0 0 1 0 1H1.732l4.096 4.096a.5.5 0 0 1 0 .707"/>
              </svg>
            </a>
          </li>
          <li class="nav-item mx-1 position-relative text-center ">
            <a class="nav-link p-2" href="javascript:void(0);" @click="theme = theme === 'light' ? 'dark' : 'light'; localStorage.setItem('theme', theme)">
              <svg x-show="theme === 'light'" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-sun" viewBox="0 0 16 16">
                <path d="M8 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6m0 1a4 4 0 1 0 0-8 4 4 0 0 0 0 8M8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0m0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13m8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5M3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8m10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0m-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0m9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707M4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708"/>
              </svg>
              <svg x-show="theme === 'dark'" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-moon-stars-fill" viewBox="0 0 16 16">
                <path d="M6 .278a.77.77 0 0 1 .08.858 7.2 7.2 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277q.792-.001 1.533-.16a.79.79 0 0 1 .81.316.73.73 0 0 1-.031.893A8.35 8.35 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.75.75 0 0 1 6 .278"/>
                <path d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.73 1.73 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.73 1.73 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.73 1.73 0 0 0 1.097-1.097zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.16 1.16 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.16 1.16 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732z"/>
              </svg>
            </a>
          </li>
          <li class="nav-item dropdown mx-1">
            <a class="nav-link p-2 position-relative text-center" href="javascript:void(0);" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-bell" viewBox="0 0 16 16">
                <path d="M8 16a2 2 0 0 0 2-2H6a2 2 0 0 0 2 2M8 1.918l-.797.161A4 4 0 0 0 4 6c0 .628-.134 2.197-.459 3.742-.16.767-.376 1.566-.663 2.258h10.244c-.287-.692-.502-1.49-.663-2.258C12.134 8.197 12 6.628 12 6a4 4 0 0 0-3.203-3.92zM14.22 12c.223.447.481.801.78 1H1c.299-.199.557-.553.78-1C2.68 10.2 3 6.88 3 6c0-2.42 1.72-4.44 4.005-4.901a1 1 0 1 1 1.99 0A5 5 0 0 1 13 6c0 .88.32 4.2 1.22 6"/>
              </svg>
              @if(auth()->user()->unreadnotifications->count())
                <span class="badge bg-primary badge-number position-absolute fw-normal rounded-circle header-notification-badge">{{ auth()->user()->unreadnotifications->count() }}</span>
              @endif
            </a><!-- End Notification Icon -->
            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
              <div class="offcanvas-header border-bottom border-light-subtle">
                <h5 class="offcanvas-title" id="offcanvasRightLabel"><span class="header-notification-badge">{{ auth()->user()->unreadnotifications->count() }}</span> New Notifications</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
              </div>
              <div class="offcanvas-body notifications">
                @if(auth()->user()->notifications->count())
                @foreach(auth()->user()->notifications()->orderBy('created_at', 'desc')->take(20)->get() as $notification)
                <div class="notification-item d-block border-bottom py-2">
                  <a href="{{$notification->data[0]['url'] ?? '' }}" onClick="fetch(`{{route('markAsRead',$notification->id)}}`,{method:'GET'});">
                    <h6 class="fw-bold text-secondary mb-1">{{$notification->data[0]['title'] ?? '' }}</h6>
                    <p class="m-0 small">{{$notification->data[0]['description'] ?? '' }}</p>
                    <div class="d-flex lh-1 justify-content-between align-items-center">
                      <span class="m-0 xs-small text-muted">{{ $notification->data[0]['action_taken_by'] ?? '' }}</span>
                      <span><small class="xs-small text-muted">{{$notification->created_at->diffForHumans() ?? '' }}</small> <i class="bi bi-check2-all fs-5 {{ $notification->read_at != '' ? 'text-primary' : 'text-secondary' }} m-0"></i></span>
                    </div>
                  </a>
                </div>
                @endforeach
                <div class="notification-spinner text-center pt-3 d-none">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                <div class="text-center pt-3">
                  <button class="btn btn-outline-primary btn-sm" onclick="loadData(20);this.parentElement.remove();">Load more</button>
                </div>
                @else
                <div class="text-center">
                  <i class="bi bi-bell fs-3"></i>
                  <p>Notifications will show here</p>
                </div>
                @endif
              </div>
              <div class="offcanvas-footer text-center p-3 border-top border-light-subtle">
                  <a href="{{ route('readAll')}}">Read all Notification</a>
              </div>
            </div>
          </li>
          <!-- End Notification Nav -->
        <li class="nav-item dropdown">
          <a class="nav-link nav-profile d-flex align-items-center p-2" href="javascript:void(0);" data-bs-toggle="dropdown">
            @if(!empty(auth()->user()->image) && Storage::disk('public')->exists(str_replace('storage/','',auth()->user()->image)))
            <img src="{{ asset(auth()->user()->image) }}" class="rounded-circle border border-primary" width="36px" alt="..." >
            @else
            <img src="{{asset('storage/defaults/user.webp')}}" class="rounded-circle border border-primary" width="36px" alt="...">
            @endif
            <span class="d-none d-md-block dropdown-toggle ps-2">{{ auth()->user()->name }} <i class="bi bi-chevron-down ms-auto"></i></span>
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header">
              <h6>{{ auth()->user()->name }}</h6>
              <span>{{ auth()->user()->name }}</span><br>
              <small>Member since {{ auth()->user()->created_at }}</small>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{ route('user.account') }}" wire:navigate>
                <i class="bi bi-gear"></i>
                <span>Account Settings</span>
              </a>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="javascript:void(0);">
                <i class="bi bi-question-circle"></i>
                <span>Need Help?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              @auth
                  <livewire:auth.logout-component />
              @endauth
            </li>
          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->
      </ul>
    </nav><!-- End Icons Navigation -->
</header>
</div>