<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{ theme: localStorage.getItem('theme') || 'light'}" :data-bs-theme="theme" data-bs-theme="">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport">
        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta name="user-id" content="{{ Auth::check() ? Auth::user()->id : '' }}">
        <title>{{ ucwords(str_replace('-',' ',request()->path())) }} - {{ Request::get('settings')[0]->value }}</title>
        <meta content="" name="description">
        <meta content="" name="keywords">
        <meta http-equiv="x-pjax-version" content="v123">
        <!-- Favicons -->
        <link href="{{ asset(Request::get('settings')[3]->value) }}" rel="icon">
        <link href="{{ asset(Request::get('settings')[3]->value) }}" rel="apple-touch-icon">
        <!-- OneSignal JavaScript -->
        {{-- <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js" defer></script> --}}
        <!-- Firebase JavaScript -->
        {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/firebase/10.12.3/firebase-app-compat.min.js" integrity="sha512-pfQbmopl1pPzwNNruNAGic4/pztqLJVStRP2BUH7n42/vIcYam8pYr066emmtLNDrO6zTRSN6z5Ic5a96nlhdw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/firebase/10.12.3/firebase-analytics-compat.min.js" integrity="sha512-x61GnMoPINsYi8n/EtnLRHgzi2qvuR7Cc35fRTFDIrQvMpipNg4rz4rYWuWsNG9dKcK9SyjkThj9ZXSx+vHhJg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/firebase/10.12.3/firebase-messaging-compat.min.js" integrity="sha512-wxoPdYbCI1HXtpnk4i+LDRyTojHm7y+gRYjozA4tX9SCbaYtTwRRouRPQBasfzqDtK+6trFYtUvIzwyX77q30A==" crossorigin="anonymous" referrerpolicy="no-referrer"></script> --}}
        <!-- Pusher JavaScript -->
        <script src="https://js.pusher.com/8.2.0/pusher.min.js?v=8.2.0"></script>
        {{-- <script src="{!! asset('admin/js/pusher_onesignal_firebase.js') !!}"></script> --}}
        <!-- cdn CSS Files -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/css/bootstrap.min.css" integrity="sha512-jnSuA4Ss2PkkikSOLtYs8BlYIeeIK1h99ty4YfvRPAlzr377vr3CXDb7sb7eEEBYjDtcYj+AjBH3FLv5uSJuXg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" integrity="sha512-dPXYcDub/aeb08c63jRq/k6GaKccl256JQy/AnOq7CAnEZ9FzSL9wSbcZkMp4R26vBsMLFYH4kQ67/bbV8XaCQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.3.2/skins/ui/oxide/skin.min.css" integrity="sha512-Sp8IOCelgead3QgJhslIseIPOohqMufXgOgqr1yRdpILROH2B+F9jMFjvY7FmALYigvUl74/qWa3K40K3fZpfg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/glightbox/3.3.0/css/glightbox.min.css" integrity="sha512-T+KoG3fbDoSnlgEXFQqwcTC9AdkFIxhBlmoaFqYaIjq2ShhNwNao9AKaLUPMfwiBPL0ScxAtc+UYbHAgvd+sjQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/5.5.4/css/fileinput.min.css" integrity="sha512-yDVMONIXJPPAoULZ92Ygngsn8ZUGB4ejm6fCc6q9ZvdH8blFAOgg75XZSEaAJ5m4E/yPI1BAi5fF2axMHVuZ5w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <!-- Tempus Dominus Styles -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempus-dominus/6.7.7/css/tempus-dominus.min.css" integrity="sha512-wO+rVZhTyJgwKxVY279cD/TZTlW2m0IJQXzoOHfj2w//md58T3jc8ZWHb+HEm8CspcCNnaJVFPyRAGd/Y4ScfA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <!-- Template Main CSS File -->
        <link rel="stylesheet" href="{!! asset('admin/css/common.css') !!}?v=1.1.1" >
        <link rel="stylesheet" href="{!! asset('admin/css/light.css') !!}?v=1.1.1" >
        <link rel="stylesheet" href="{!! asset('admin/css/dark.css') !!}?v=1.1.1" >
        <!-- Tempus Dominus JavaScript -->
        <script data-navigate-once src="https://cdnjs.cloudflare.com/ajax/libs/tempus-dominus/6.7.7/js/tempus-dominus.min.js" integrity="sha512-jBIYFo+QKM9WQBcWjg/NW/GOxnZAJ2vzheAjhmkhX01LSMjVB3rkytETvH/hBnCMtiHBqaxgoSVlomL5isTJsw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    </head>
    <body x-data="{ sidebar: localStorage.getItem('sidebar') || '' }" :class="sidebar" class="font-sans antialiased">
        @include('components.layouts.header')
        @include('components.layouts.sidebar')
        <main class="main" id="main">
            {{ $slot }}
        </main>
        @include('components.layouts.footer')
        @include('components.layouts.scripts')
    </body>
</html>
