@props([
    'messages'  =>  false,
    'model'     =>  '', // for wire.modal
    'type'      =>  'text', // input type
    'name'      =>  '', // input name
    'id'        =>  '', // input id
    'label'     =>  '', // inputal label text for uniwue
    'invalid'   =>  !empty($messages) ? 'invalid-server' : '', // for error validation
])
@if($type == 'checkbox')
    <input @if(!empty($name)) wire:model{{ $model }}="{{ $name }}" @endif {{ $attributes->merge(['name'=>''.$name, 'type' => ''.$type,'value' => '','class' => 'form-check-input'.$invalid,'placeholder' => '#','autocomplete' => 'off','id' => ''.!empty($id) ? $id : $name,'style' => '',]) }} null/>
    <label for="{{ !empty($id) ? $id : $name }}" class="form-check-label mt-1 ps-2">{{ !empty($label) ? str_replace('_',' ',$label) : str_replace('_',' ',$name) }}</label>
    @if ($messages)
    @foreach ((array) $messages as $message)
    <span {{ $attributes->merge(['class' => 'invalid-server-feedback mt-1']) }} role="alert">{{ $message }}</span>
    @endforeach
    @endif
@elseif($type == 'radio')
    <input @if(!empty($name)) wire:model{{ $model }}="{{ $name }}" @endif {{ $attributes->merge(['name'=>''.$name, 'type' => ''.$type,'value' => '','class' => 'form-check-input'.$invalid,'placeholder' => '#','autocomplete' => 'off','id' => ''.!empty($id) ? $id : $name,'style' => '',]) }} null>
    <label class="form-check-label ms-2" for="{{ !empty($id) ? $id : $name }}">{{ !empty($label) ? str_replace('_',' ',$label) : str_replace('_',' ',$name) }}</label>
    @if ($messages)
        @foreach ((array) $messages as $message)
        <span {{ $attributes->merge(['class' => 'invalid-server-feedback mt-1']) }} role="alert">{{ $message }}</span>
        @endforeach
    @endif
@elseif($type == 'file')
    <input @if(!empty($name)) wire:model{{ $model }}="{{ $name }}" @endif {{ $attributes->merge(['name'=>''.$name, 'type' => ''.$type,'value' => '','class' => 'form-control '.$invalid,'placeholder' => '#','autocomplete' => 'off','id' => ''.!empty($id) ? $id : $name,'style' => '',]) }} null>
    @if ($messages)
        @foreach ((array) $messages as $message)
        <span {{ $attributes->merge(['class' => 'invalid-server-feedback mt-1']) }} role="alert">{{ $message }}</span>
        @endforeach
    @endif
@else
    <div class="form-floating">
        <input @if(!empty($name)) wire:model{{ $model }}="{{ $name }}" @endif {{ $attributes->merge(['name'=>''.$name, 'type' => ''.$type,'value' => '','class' => 'form-control '.$invalid,'placeholder' => '#','autocomplete' => 'off','id' => ''.!empty($id) ? $id : $name,'style' => '',]) }}/>
        <label for="{{ !empty($id) ? $id : $name }}" class="text-capitalize">{{ !empty($label) ? str_replace('_',' ',$label) : str_replace('_',' ',$name) }}</label>
        @if ($messages)
            @foreach ((array) $messages as $message)
            <span {{ $attributes->merge(['class' => 'invalid-server-feedback mt-1']) }} role="alert">{{ $message }}</span>
            @endforeach
        @endif
    </div>
@endif

