<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Account <small class="fs-6">Settings</small></h5>
            </div>
            <div class="col">
                {{--
                <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                --}}
            </div>
        </div>
    </section>
    <section class="section profile">
        <div class="row row-cols-1 row-cols-sm-1 row-cols-lg-2 g-3 g-lg-3">
            <div class="col">
                <div class="card mb-3 shadow-sm">
                    <div class="card-body profile-card d-flex flex-column">
                        <div class="d-inline-flex align-middle align-items-center mb-3">
                            <a href="{{ route('user.account') }}" class="me-4" wire:navigate>
                                @if(!empty(auth()->user()->image) && Storage::disk('public')->exists(str_replace('storage/','',auth()->user()->image)))
                                <img class="img-thumbnail shadow-sm d-block img-thumbnail" src="{{ asset(auth()->user()->image) }}" width="100px" alt="..." />
                                @else
                                <img class="img-thumbnail shadow-sm d-block img-thumbnail" src="{{asset('storage/defaults/user.webp')}}" width="100px" alt="..." />
                                @endif
                            </a>
                            <a href="{{ route('user.account') }}" wire:navigate>
                                <h2>{{ auth()->user()->name }}</h2>
                                <small class="d-block text-muted">Date of Join : {{ date('d M y',strtotime(auth()->user()->joining_date)) }}</small>
                                <small class="d-block text-muted">Registred since : {{ date('d M y h:i a',strtotime(auth()->user()->created_at)) }}</small>
                            </a>
                        </div>
                        <h5 class="card-title">About</h5>
                        <p class="small fst-italic">{{ auth()->user()->about }}</p>
                    </div>
                </div>
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary">Personal Information</div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6 col-lg-3 col-md-4 fw-bold text-secondary">Full Name</div>
                            <div class="col-6 col-lg-9 col-md-8">{{ auth()->user()->name }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 col-lg-3 col-md-4 fw-bold text-secondary">Nationality</div>
                            <div class="col-6 col-lg-9 col-md-8">{{ auth()->user()->nationality }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 col-lg-3 col-md-4 fw-bold text-secondary">Gender</div>
                            <div class="col-6 col-lg-9 col-md-8">{{ auth()->user()->gender }}</div>
                        </div>
                    </div>
                </div>
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary">Contact Information</div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-3 col-md-4 fw-bold text-secondary">Phone</div>
                            <div class="col-lg-9 col-md-8"><a href="tel:{{ auth()->user()->phone }}">{{ auth()->user()->phone }}</a></div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-4 fw-bold text-secondary">Email</div>
                            <div class="col-lg-9 col-md-8"><a href="mailto:{{ auth()->user()->email }}">{{ auth()->user()->email }}</a></div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-4 fw-bold text-secondary">Address</div>
                            <div class="col-lg-9 col-md-8">{{ auth()->user()->address }}</div>
                        </div>
                    </div>
                </div>
                <div class="card mb-3 shadow-sm">
                    @if(!empty(auth()->user()->two_factor_secret) && empty(auth()->user()->two_factor_confirmed_at))
                    <form wire:submit="verify" class="needs-validation" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    @endif
                    <div class="card-header py-3 d-flex justify-content-between align-items-center">
                        <div class="fs-6 text-body-tertiary">Two Factor Authentication</div>
                        @if(empty(auth()->user()->two_factor_secret) && empty(auth()->user()->two_factor_confirmed_at))
                        <div class="text-danger">Currently not enabled</div>
                        @else
                        <div class="text-success">2FA Enabled</div>
                        @endif
                    </div>
                    <div class="card-body">
                        <div class="small text-muted fw-bold">
                            Add additional security to your account using two factor authentication.
                        </div>
                        <p class="text-muted small">
                            When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone's Google Authenticator application.
                        </p>
                        @if(!empty(auth()->user()->two_factor_confirmed_at))
                            <div class="mb-3">
                                <div class="small text-muted fw-bold mb-3">
                                    Store these recovery codes in a secure password manager. They can be used to recover access to your account if your two factor authentication device is lost.
                                </div>
                                <div class="p-3 bg-light rounded">
                                    <div class="row row-cols-2 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-2">
                                        @foreach(auth()->user()->getRecoveryCodes() as $code)
                                        <div class="col">{{ $loop->iteration }}. {{ $code }}</div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if(!empty(auth()->user()->two_factor_secret) && empty(auth()->user()->two_factor_confirmed_at))
                            <div class="mb-3">
                                <div class="small text-muted fw-bold mb-3">
                                    To finish enabling two factor authentication, scan the following QR code using your phone's authenticator application or enter the setup key and provide the generated OTP code.
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    {!! auth()->user()->twoFactorQrCodeSvg() !!}
                                    <div>
                                        <div class="small text-muted fw-bold">Or enter this secret key manually</div>
                                        <strong>Setup Key:</strong> <code>{{ Crypt::decrypt(auth()->user()->two_factor_secret) }}</code>
                                    </div> 
                                </div>
                            </div>
                            <x-input-floating type="text" name="code" :messages="$errors->get('code')" />
                        @endif
                    </div>
                    <div class="card-footer py-2">
                        @if(!empty(auth()->user()->two_factor_secret) && empty(auth()->user()->two_factor_confirmed_at))
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="verify" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Confirm') }}
                        </button>
                        <button type="button" wire:click="disable2FA" class="btn btn-danger" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="disable2FA" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Cancel') }}
                        </button>
                        @elseif(!empty(auth()->user()->two_factor_secret) && !empty(auth()->user()->two_factor_recovery_codes) && !empty(auth()->user()->two_factor_confirmed_at) )
                        <button type="button" wire:click="regenerateRocoveryCodes" class="btn btn-dark" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="regenerateRocoveryCodes" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Regenerate Rocovery Codes') }}
                        </button>
                        <button type="button" wire:click="disable2FA" class="btn btn-danger" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="disable2FA" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Disable 2FA') }}
                        </button>
                        @else
                        <button type="button" wire:click="enable2FA" class="btn btn-dark" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="enable2FA" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Enable 2FA') }}
                        </button>
                        @endif
                    </div>
                </form>
                </div>
            </div>

            <div class="col">
                <div class="card mb-3 shadow-sm">
                    <form wire:submit="updateAccount" class="needs-validation" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                        <div class="card-header py-3">
                            <div class="fs-6 text-body-tertiary">Profile Update</div>
                        </div>
                        <div class="card-body">
                            <div  class="row row-cols-1 row-cols-lg-1 g-3 g-lg-3">
                                <div class="col">
                                    @if(!empty(auth()->user()->image) && Storage::disk('public')->exists(str_replace('storage/','',auth()->user()->image)))
                                    <img class="img-thumbnail shadow-sm d-block img-thumbnail" src="{{ asset(auth()->user()->image) }}" width="100px" alt="..." />
                                    @else
                                    <img class="img-thumbnail shadow-sm d-block img-thumbnail" src="{{asset('storage/defaults/user.webp')}}" width="100px" alt="..." />
                                    @endif
                                </div>
                                <div class="col">
                                    <x-input-floating type="file" name="image" :messages="$errors->get('image')" />
                                </div>
                                <div class="col">
                                    <x-input-floating name="name" :messages="$errors->get('name')" />
                                </div>
                                <div class="col">
                                    <x-input-floating name="phone" :messages="$errors->get('phone')" />
                                </div>
                                <div class="col">
                                    <x-input-floating type="email" name="email" :messages="$errors->get('email')" />
                                </div>
                                <div class="col">
                                    <x-input-floating name="date_of_birth" class="datepicker" :messages="$errors->get('date_of_birth')" />
                                </div>
                                <div class="col">
                                    <div class="form-check">
                                        <x-input-floating type="checkbox" name="change_password" :messages="$errors->get('change_password')" label="Change Password ? " />
                                    </div>
                                </div>
                                <div class="col">
                                    <x-input-floating name="password" :messages="$errors->get('password')" />
                                </div>
                                <div class="col">
                                    <x-input-floating name="password_confirmation" :messages="$errors->get('password_confirmation')" />
                                </div>
                            </div>
                        </div>
                        <div class="card-footer py-2">
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="updateAccount" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary">Browser Sessions</div>
                    </div>
                    <div class="card-body">
                        <div class="small text-muted fw-bold">Manage and log out your active sessions on other browsers and devices.</div>
                        <p class="text-muted small mb-0">
                            If necessary, you may log out of all of your other browser sessions across all of your devices. Some of your recent sessions are listed below; however, this list may not be exhaustive. If you feel your account
                            has been compromised, you should also update your password.
                        </p>

                        <!-- Other Browser Sessions -->
                        @if (count($this->sessions) > 0)
                        @foreach($this->sessions as $session)
                        <div class="d-flex align-items-center mt-3">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-laptop text-body-tertiary" viewBox="0 0 16 16">
                                    <path d="M13.5 3a.5.5 0 0 1 .5.5V11H2V3.5a.5.5 0 0 1 .5-.5zm-11-1A1.5 1.5 0 0 0 1 3.5V12h14V3.5A1.5 1.5 0 0 0 13.5 2zM0 12.5h16a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5" />
                                </svg>
                            </div>
                            <div class="ms-3">
                                <div class="text-muted">{{ $session->agent }}</div>
                                <div class="small text-muted">
                                    {{ $session->ip_address }},
                                    @if($session->is_current_device)
                                    <span class="text-success fw-bold">This Device</span>
                                    @else
                                    <span class="text-muted">Last active {{ $session->last_active }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @endif
                    </div>
                    <div class="card-footer py-2">
                        <button type="button" wire:click="create" class="btn btn-dark" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading wire:target="create" class="spinner-border spinner-border-sm me-2"></span>
                            {{ __('Log Out Other Browser Sessions') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
     <!-- Create Modal -->
     @include('admin.auth.logout-other-browser-sessions')
</div>
<script>
    document.querySelectorAll(".datepicker").forEach(function (element) {
        new tempusDominus.TempusDominus(element, {
            localization: { format: "yyyy-MM-dd" },
            display: {
                icons: {
                    type: "icons",
                    time: "bi bi-clock",
                    date: "bi bi-calendar",
                    up: "bi bi-arrow-up",
                    down: "bi bi-arrow-down",
                    previous: "bi bi-chevron-left",
                    next: "bi bi-chevron-right",
                    today: "bi bi-calendar-check",
                    clear: "bi bi-trash3",
                    close: "bi bi-x",
                },
                components: { calendar: true, date: true, month: true, year: true, decades: true, clock: false, hours: true, minutes: true, seconds: false, useTwentyfourHour: undefined },
            },
        });
        element.addEventListener("change.td", (event) => {
            const selectedDate = event.detail.date?.toISOString().split("T")[0]; // Format as 'yyyy-MM-dd'
            console.log(selectedDate);
            if (selectedDate) {
                // Update the input field value
                element.value = selectedDate;
                // Trigger the input event to notify Livewire of the change
                const inputEvent = new Event("input", { bubbles: true });
                element.dispatchEvent(inputEvent);
            }
        });
    });
</script>
@script
<script>
    $wire.on('showModal', (event) => {
        setTimeout(function () {
            const modal = new bootstrap.Modal(document.getElementById(event[0].modal));
            modal.show();
        },0);
    });
    $wire.on('hideModal', (event) => {
        setTimeout(function () {
            const modalElement = document.getElementById(event[0].modal);
            const modal = bootstrap.Modal.getInstance(modalElement);
            modal.hide();
            Livewire.dispatch(event[0].modal);
        },0);
    });
</script>
@endscript
