<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Social Settings</h5>
            </div>
            <div class="col">
                {{-- <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> --}}
            </div>
        </div>
    </section>
    <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-3 g-lg-3">
        <div class="col">
            <section class="content">
                <form wire:submit="updateSocialSettings" class="needs-validation" accept-charset="UTF-8" novalidate>
                    <div class="card mb-3 shadow-sm">
                        <div class="card-header py-3">
                            <div class="fs-6 text-body-tertiary">Update User Social Login Settings</div>
                        </div>
                            <div class="card-body">
                                <div class="row row-cols-1 row-cols-lg-2 g-3 g-lg-3">
                                    <div class="col">
                                        <div class="text-primary text-center mb-3">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope-fill" viewBox="0 0 16 16">
                                                <path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414zM0 4.697v7.104l5.803-3.558zM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586zm3.436-.586L16 11.801V4.697z"/>
                                              </svg>
                                            Email / Phone
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="login_with_email" :messages="$errors->get('login_with_email')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="login_with_phone" :messages="$errors->get('login_with_phone')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="login_with_username" :messages="$errors->get('login_with_username')"/>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="text-primary text-center mb-3">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-apple" viewBox="0 0 16 16">
                                                <path d="M11.182.008C11.148-.03 9.923.023 8.857 1.18c-1.066 1.156-.902 2.482-.878 2.516s1.52.087 2.475-1.258.762-2.391.728-2.43m3.314 11.733c-.048-.096-2.325-1.234-2.113-3.422s1.675-2.789 1.698-2.854-.597-.79-1.254-1.157a3.7 3.7 0 0 0-1.563-.434c-.108-.003-.483-.095-1.254.116-.508.139-1.653.589-1.968.607-.316.018-1.256-.522-2.267-.665-.647-.125-1.333.131-1.824.328-.49.196-1.422.754-2.074 2.237-.652 1.482-.311 3.83-.067 4.56s.625 1.924 1.273 2.796c.576.984 1.34 1.667 1.659 1.899s1.219.386 1.843.067c.502-.308 1.408-.485 1.766-.472.357.013 1.061.154 1.782.539.571.197 1.111.115 1.652-.105.541-.221 1.324-1.059 2.238-2.758q.52-1.185.473-1.282"/>
                                                <path d="M11.182.008C11.148-.03 9.923.023 8.857 1.18c-1.066 1.156-.902 2.482-.878 2.516s1.52.087 2.475-1.258.762-2.391.728-2.43m3.314 11.733c-.048-.096-2.325-1.234-2.113-3.422s1.675-2.789 1.698-2.854-.597-.79-1.254-1.157a3.7 3.7 0 0 0-1.563-.434c-.108-.003-.483-.095-1.254.116-.508.139-1.653.589-1.968.607-.316.018-1.256-.522-2.267-.665-.647-.125-1.333.131-1.824.328-.49.196-1.422.754-2.074 2.237-.652 1.482-.311 3.83-.067 4.56s.625 1.924 1.273 2.796c.576.984 1.34 1.667 1.659 1.899s1.219.386 1.843.067c.502-.308 1.408-.485 1.766-.472.357.013 1.061.154 1.782.539.571.197 1.111.115 1.652-.105.541-.221 1.324-1.059 2.238-2.758q.52-1.185.473-1.282"/>
                                              </svg>
                                            Apple
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="apple_login" :messages="$errors->get('apple_login')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="apple_app_id" :messages="$errors->get('apple_app_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="apple_secret_id" :messages="$errors->get('apple_secret_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="apple_callback_url" :messages="$errors->get('apple_callback_url')"/>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="text-primary text-center mb-3">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-google" viewBox="0 0 16 16">
                                                <path d="M15.545 6.558a9.4 9.4 0 0 1 .139 1.626c0 2.434-.87 4.492-2.384 5.885h.002C11.978 15.292 10.158 16 8 16A8 8 0 1 1 8 0a7.7 7.7 0 0 1 5.352 2.082l-2.284 2.284A4.35 4.35 0 0 0 8 3.166c-2.087 0-3.86 1.408-4.492 3.304a4.8 4.8 0 0 0 0 3.063h.003c.635 1.893 2.405 3.301 4.492 3.301 1.078 0 2.004-.276 2.722-.764h-.003a3.7 3.7 0 0 0 1.599-2.431H8v-3.08z"/>
                                              </svg>
                                            Google
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="google_login" :messages="$errors->get('google_login')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="google_app_id" :messages="$errors->get('google_app_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="google_secret_id" :messages="$errors->get('google_secret_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="google_callback_url" :messages="$errors->get('google_callback_url')"/>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="text-primary text-center mb-3">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                                                <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951"/>
                                              </svg>
                                            Facebook
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="facebook_login" :messages="$errors->get('facebook_login')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="facebook_app_id" :messages="$errors->get('facebook_app_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="facebook_secret_id" :messages="$errors->get('facebook_secret_id')"/>
                                        </div>
                                        <div class="mb-3">
                                            <x-input-floating name="facebook_callback_url" :messages="$errors->get('facebook_callback_url')"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer d-flex justify-content-around py-2">
                                <button type="reset" class="btn btn-warning">Reset</button>
                                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                    <span wire:loading wire:target="updateSocialSettings" class="spinner-border spinner-border-sm me-2"></span>
                                    {{ __('Submit') }}
                                </button>
                            </div>
                    </div>
                </form>
            </section>
        </div>
        <div class="col">
            @canany(['view_socialsettings','view_all'])
            <section class="content">
                <form wire:submit="updateSocialLinks" class="needs-validation"  accept-charset="UTF-8" novalidate>
                    <div class="card mb-3 shadow-sm">
                        <div class="card-header py-3">
                            <div class="fs-6 text-body-tertiary">Update Social Links</div>
                        </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <x-input-floating name="facebook_url" :messages="$errors->get('facebook_url')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="instagram_url" :messages="$errors->get('instagram_url')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="linkedin_url" :messages="$errors->get('linkedin_url')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="twitter_url" :messages="$errors->get('twitter_url')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="youtube_url" :messages="$errors->get('youtube_url')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="tiktok_url" :messages="$errors->get('tiktok_url')"/>
                                </div>
                                
                                    <x-input-floating name="snapchat_url" :messages="$errors->get('snapchat_url')"/> 
                                
                            </div>
                            <div class="card-footer d-flex justify-content-around py-2">
                                <button type="reset" class="btn btn-warning">Reset</button>
                                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                    <span wire:loading wire:target="updateSocialLinks" class="spinner-border spinner-border-sm me-2"></span>
                                    {{ __('Submit') }}
                                </button>
                            </div>
                    </div>
                </form>
            </section>
            @endcanany
        </div>
    </div>
    
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
