<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Alert Settings</h5>
            </div>
            <div class="col"></div>
        </div>
    </section>
    <section>
        <div class="row row-cols-1 row-cols-lg-2 g-3 g-lg-3">
            <div class="col">
                @canany(['view_socialsettings','view_all'])
                <form wire:submit="updateEnv" class="needs-validation" accept-charset="UTF-8" novalidate>
                    <div class="card  shadow-sm">
                        <div class="card-header py-3">
                            <div class="fs-6 text-body-tertiary">Env Settngs</div>
                        </div>
                        <div class="card-body">
                            <div class="row row-cols-1 row-cols-lg-3 g-3 g-lg-3">
                                <div class="col">
                                    <div class="text-primary text-center mb-3">Mail Settings</div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_mailer" :messages="$errors->get('mail_mailer')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_host" :messages="$errors->get('mail_host')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_port" :messages="$errors->get('mail_port')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_username" :messages="$errors->get('mail_username')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_password" :messages="$errors->get('mail_password')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_encryption" :messages="$errors->get('mail_encryption')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="mail_from_address" :messages="$errors->get('mail_from_address')" />
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="text-primary text-center mb-3">Pusher Settings</div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_app_id" :messages="$errors->get('pusher_app_id')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_app_key" :messages="$errors->get('pusher_app_key')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_app_secret" :messages="$errors->get('pusher_app_secret')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_host" :messages="$errors->get('pusher_host')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_port" :messages="$errors->get('pusher_port')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_scheme" :messages="$errors->get('pusher_scheme')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="pusher_app_cluster" :messages="$errors->get('pusher_app_cluster')" />
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="text-primary text-center mb-3">AWS Settings</div>
                                    <div class="mb-3">
                                        <x-input-floating name="aws_access_key_id" :messages="$errors->get('aws_access_key_id')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="aws_secret_access_key" :messages="$errors->get('aws_secret_access_key')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="aws_default_region" :messages="$errors->get('aws_default_region')" />
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="aws_bucket" :messages="$errors->get('aws_bucket')" />
                                    </div>
                                </div>
                            </div>
                            <div class="text-muted small"><strong>Note:</strong> After updateing these settings update application mode in general settings to take affect. </div>
                        </div>
                        <div class="card-footer d-flex justify-content-around py-2">
                            <button type="reset" class="btn btn-warning">Reset</button>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:target="updateEnv" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="updateEnv" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
                @endcanany
            </div>
            <div class="col">
                @canany(['view_pushsettings','view_all'])
                <form wire:submit="pushOnesignalFirebase" class="needs-validation" accept-charset="UTF-8" novalidate>
                    <div class="card shadow-sm">
                        <div class="card-header py-3">
                            <div class="fs-6 text-body-tertiary">Update Push Notification</div>
                        </div>
                        <div class="card-body">
                            <div class="text-primary text-center mb-3">Onesignal Push Notifications</div>
                            <div class="mb-3">
                                <x-input-floating name="onesignal_push" :messages="$errors->get('onesignal_push')" />
                            </div>
                            <div class="mb-3">
                                <x-input-floating name="onesignal_app_id" :messages="$errors->get('onesignal_app_id')" />
                            </div>
                            <div class="mb-3">
                                <x-input-floating name="onesignal_secret_id" :messages="$errors->get('onesignal_secret_id')" />
                            </div>
                            <div class="text-primary text-center mb-3">Firebase Push Notifications</div>
                            <div class="mb-3">
                                <x-input-floating name="firebase_push" :messages="$errors->get('firebase_push')" />
                            </div>
                            <x-input-floating name="firebase_secret_id" :messages="$errors->get('firebase_secret_id')" />
                        </div>
                        <div class="card-footer d-flex justify-content-around py-2">
                            <button type="reset" class="btn btn-warning">Reset</button>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="pushOnesignalFirebase" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
                @endcanany
            </div>
        </div>
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
