<div> 
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Rooms <small class="fs-6">List</small></h5>
            </div>
            <div class="col">
                {{-- <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> --}}
            </div>
        </div>
    </section>
    <div x-data="{deleteId:[]}" class="card shadow-sm">
        <div x-data="{ filter: localStorage.getItem('filter') || 'show' }" class="accordion" id="accordionPanelsStayOpenExample">
            <div class="accordion-item rounded-top rounded-bottom-0 border-0">
            <h2 class="accordion-header p-2 d-flex" id="panelsStayOpen-headingOne">
                <button @click="filter = filter === 'show' ? 'hide' : 'show'; localStorage.setItem('filter', filter)" class="accordion-button shadow-none p-1" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true" aria-controls="panelsStayOpen-collapseOne">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
                <a href="{{ route('room') }}" wire:navigate class="btn btn-light border-light-subtle text-nowrap me-1" role="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-repeat" viewBox="0 0 16 16">
                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41m-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9"/>
                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5 5 0 0 0 8 3M3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9z"/>
                    </svg>
                    Reload
                </a>
                @canany(['create_room','create_all'])
                <button type="button" class="btn btn-success text-nowrap" wire:click="create" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2"></path>
                    </svg>
                    <span wire:loading wire:target="create" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                    New
                </button>
                @endcanany
            </h2>
            <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse" :class="filter" aria-labelledby="panelsStayOpen-headingOne">
                <div class="accordion-body border-top px-3">
                        <div class="row row-cols-2 row-cols-lg-4 g-3 g-lg-3">
                            <div class="col grid-select-all-btn d-none">
                                <div class="btn-group w-100">
                                    @canany(['delete_room','delete_all'])
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <button class="dropdown-item text-danger" x-on:click="deleteId" data-bs-toggle="modal" data-bs-target="#confirmModal">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3 fs-6" viewBox="0 0 16 16">
                                                    <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                                                </svg> 
                                            Bulk Delete
                                            </button>
                                        </li>
                                    </ul>
                                    @endcanany
                                    <button type="button" class="btn border selected w-100">0 selected</button>
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item grid-batch-0 text-secondary" href="javascript:void(0);" onclick="printThis('{{ route('role','print') }}')"><i class="bi bi-printer-fill fs-6"></i> Print</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-info" href="javascript:void(0);" onclick="exportRecords('{{ route('role','csv') }}')"><i class="bi bi-filetype-csv fs-6"></i> Export CSV</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-success" href="javascript:void(0);" onclick="exportRecords('{{ route('role','excel') }}')"><i class="bi bi-filetype-exe fs-6"></i> Export Excel</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col">
                                <x-input-floating model=".live.debounce.300ms" name="search" placeholder="Search..." />
                            </div>
                         
                        </div>
                    
                </div>
            </div>
            </div>
        </div>
            <div class="row">
                    <div class="col-md-12">
                        <div class="position-relative w-100">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="form-check-input" onclick="selectAll();" value="" id="selectAll"/>
                                                </div>
                                            </th>
                                            <th>ID</th>
                                            <th>Photos</th>
                                            <th>Name</th>
                                            <th>Price</th>
                                            <th>Space</th>
                                            <th>Capacity</th>
                                            <th>Short Description</th>
                                            @canany(['status_room','status_all'])
                                            <th>Status</th>
                                            @endcanany	
                                            @canany(['update_room','delete_room','update_all','delete_all'])
                                            <th class="text-center">Action</th>
                                            @endcanany
                                        </tr>
                                    </thead>
                                    @if($collection->count())
                                    <tbody>
                                        @foreach($collection as  $item)
                                        <tr data-key="{{ $item->id }}">
                                            <td>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="grid-row-checkbox" onclick="rowCheckbox(this);" value="{{ $item->id }}" id="{{ $item->id }}"/>
                                                </div>
                                            </td>
                                            <td>{{ $item->id }}</td>
                                            <td>
                                               
                                                @if(count($item->photos)>0)
                                                <a href="{{ Storage::disk('public')->exists(str_replace('storage/', '', $item->photos->first()->photo)) ? asset($item->photos->first()->photo) : asset('storage/defaults/photo.webp') }}" class="glightbox">
                                                    <img src="{{ Storage::disk('public')->exists(str_replace('storage/', '', $item->photos->first()->photo)) ? asset($item->photos->first()->photo) : asset('storage/defaults/photo.webp') }}" class="rounded border" width="50px" alt="">
                                                </a>
                                                @else
                                                <a href="{{ asset('storage/defaults/photo.webp') }}" class="glightbox">
                                                    <img src="{{ asset('storage/defaults/photo.webp') }}" class="rounded border" width="50px" alt="">
                                                </a>
                                                @endif
                                            </td>
                                            <td>
                                            @foreach($languages as $language)
                                                {{ $item->translation($language->id)?->name }}<br>
                                            @endforeach
                                            </td>
                                            <td>{{ $item->price }}</td>
                                            <td>{{ $item->space }}</td>
                                            <td>
                                                @foreach($languages as $language)
                                                    {{ $item->translation($language->id)?->capacity }}<br>
                                                @endforeach
                                            </td>
                                            <td>
                                                <textarea rows="4" cols="50" class="border-0" id="{{ $item->image }}">{{ implode("\n", $languages->map(fn($language) => $item->translation($language->id)?->short_description)->toArray()) }}</textarea>
                                            </td>
                                            @canany(['status_room','status_all'])
                                            <td>
                                                <label class="toggle" for="{{ $item->id.$item->status }}">
                                                    <input type="checkbox"  @if($item->status=='Active') checked @endif id="{{ $item->id.$item->status }}">
                                                    <span class="slider "></span>
                                                    <span class="labels" data-on="Active" data-off="InActive" wire:click="status({{ $item->id }})"></span>
                                                </label>
                                            </td>
                                            @endcanany
                                            @canany(['update_room','delete_room','update_all','delete_all'])
                                            <td x-data="{id:null}" class="text-center">
                                                <a href="javascript:void(0);" class="dropdown dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                                        <path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0"/>
                                                    </svg>
                                                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow mt-2 z-3">
                                                        @canany(['update_room','update_all'])
                                                        <li>
                                                            <button class="dropdown-item text-info" type="button" wire:click="edit({{ $item->id }})">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                                    <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                                                    <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
                                                                </svg>
                                                                Edit
                                                            </button>
                                                        </li>
                                                        @endcanany
                                                        @canany(['delete_room','delete_all'])
                                                        <li>
                                                            <button class="dropdown-item text-danger" type="button" data-bs-toggle="modal" data-bs-target="#confirmModal" x-on:click="deleteId=[{{ $item->id }}]">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                                    <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                                    <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                                                </svg>
                                                                Delete
                                                            </button>
                                                        </li>
                                                        @endcanany
                                                    </ul>
                                                </a>
                                            </td>
                                            @endcanany
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    @else
                                    <tfoot>
                                        <tr>
                                            <th colspan="10">No record found</th>
                                        </tr>
                                    </tfoot>
                                    @endif
                                </table>
                            </div>
                            {{$collection->onEachSide(1)->links('components.layouts.pagination')}}
                        </div>
                       
                    </div>
                </div>
                <!-- Confirm Modal Modal -->
    @include('components.layouts.confirm-modal')
            </div>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
    <!-- Custom Loader -->
    <x-custom-loader targets="search"/>
    <div x-data="{ modalTitle: '' }" x-init="@this.on('showModal', (event) => {modalTitle = event[0].title;})">
        @if($createModal)
        <div class="modal fade" id="createModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true" wire:ignore.self>
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <form wire:submit="save" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                        <div class="modal-header">
                            <div class="modal-title fs-6" x-text="modalTitle"></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('createModal')"></button>
                        </div>
                        <div class="modal-body mx-md-3">
                            <div class="row">
                                <div class="col-md-6">
                                    @foreach($languages as $language)
                                    <div class="mb-3">
                                        <x-input-floating name="translations.{{ $language->id }}.name" label="Name ({{ $language->name }})" :messages="$errors->get('translations.'.$language->id.'.name')"/>
                                    </div>
                                    <div class="mb-3">
                                        <x-textarea-floating name="translations.{{ $language->id }}.short_description" label="Short Description ({{ $language->name }})" :messages="$errors->get('translations.'.$language->id.'.short_description')" style="min-height:100px;"/>
                                    </div>
                                    @endforeach
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <livewire:admin.choices-component model="room_facilities" :options="$facilities" :selected="$room_facilities" :multiple="true"/>
                                        <x-input-error :messages="$errors->get('room_facilities')"/>
                                    </div>
                                    <div class="mb-3">
                                        <livewire:admin.choices-component model="room_services" :options="$services" :selected="$room_services" :multiple="true"/>
                                        <x-input-error :messages="$errors->get('room_services')"/>
                                    </div>
                                    <div class="mb-3">
                                        <livewire:admin.choices-component model="room_privileges" :options="$privileges" :selected="$room_privileges" :multiple="true"/>
                                        <x-input-error :messages="$errors->get('room_privileges')"/>
                                    </div>
                                    @foreach($languages as $language)
                                    <div class="mb-3">
                                        <x-input-floating name="translations.{{ $language->id }}.capacity" label="Capacity ({{ $language->name }})" :messages="$errors->get('translations.'.$language->id.'.capacity')"/>
                                    </div>
                                    @endforeach
                                    <div class="mb-3">
                                        <x-input-floating name="price" :messages="$errors->get('price')"/>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="space" :messages="$errors->get('space')"/>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    @foreach($languages as $language)
                                    <div class="mb-3">
                                        <x-textarea-floating class="tinymce-editor" id="tinymce-editor-{{ $language->id }}" data-lang="{{ $language->id }}" name="translations.{{ $language->id }}.description" label="Description ({{ $language->name }})" :messages="$errors->get('translations.'.$language->id.'.description')" style="min-height:100px;"/>
                                    </div>
                                    @endforeach
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3" wire:ignore> 
                                        <input type="file" wire:model="photos" name="photos" data-browse-label="Browse" data-msg-placeholder="Upload room photos" data-max-file-count="10" data-max-file-size="10240" data-allowed-file-extensions='["jpeg", "jpg", "png", "webp","mp4"]' multiple />
                                        <x-input-error :messages="$errors->get('images')"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="reset" class="btn btn-warning">Reset</button>
                            <div>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('createModal')">Close</button>
                                <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                    <span wire:loading wire:target="save" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                    {{ __('Submit') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@script
    <script>
        $wire.on('showModal', (event) => {
            setTimeout(function () {
                const modal = new bootstrap.Modal(document.getElementById(event[0].modal));
                modal.show();
                initTinyMCE('.tinymce-editor', 'updateDescription');
                const photos = event[0].photos || []; // fallback to empty array
                let initialPreview = photos.map(photo => photo.url);
                let initialPreviewConfig = photos.map(photo => ({
                    caption: photo.name,
                    key: photo.id,
                    downloadUrl: photo.url,
                    showDelete: false,
                }));
                $('input[type="file"]').fileinput({
                    overwriteInitial: false,
                    initialPreviewAsData: true,
                    showRemove: false,
                    showUpload: false,
                    showCancel: false,
                    dropZoneEnabled: false,
                    initialPreview: initialPreview,
                    initialPreviewConfig:initialPreviewConfig,
                });
                $(document).on('click', '.kv-file-remove', function (e) {
                    e.preventDefault();
                    let button = $(this);
                    let photoId = button.data('key');
                    if (photoId) {
                        $wire.deletePhoto(photoId).then(() => {
                            // Remove the preview frame containing this button
                            button.closest('.file-preview').remove();
                        });
                    }
                });
            },0);
        });
        $wire.on('hideModal', (event) => {
            setTimeout(function () {
                const modalElement = document.getElementById(event[0].modal);
                const modal = bootstrap.Modal.getInstance(modalElement);
                modal.hide();
                Livewire.dispatch(event[0].modal);
            },0);
        });
    </script>
@endscript



