<div>
    @if($createModal)
    <!-- Bootstrap Modal -->
    <div class="modal fade" id="createModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form wire:submit="store" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    <div class="modal-header">
                        <div class="modal-title fs-6">Create New Permission</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('createModal')"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <x-input-floating name="name" :messages="$errors->get('name')"/>
                        </div>
                        <div class="mb-3">
                            <x-textarea-floating name="description" :messages="$errors->get('description')" placeholder="Write permission description here...." style="min-height:100px;"/>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <div>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('createModal')">Close</button>
                            <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="store" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>