<div> 
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Gallery Photos <small class="fs-6">List</small></h5>
            </div>
            <div class="col">
                {{-- <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> --}}
            </div>
        </div>
    </section>
    <div x-data="{deleteId:[]}" class="card shadow-sm">
        <div class="p-3">
            <div class="d-grid" style="grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
                @if($collection->count())
                @foreach($collection as $item)
                <div class="text-center rounded border p-2">
                    <a href="{{ asset($item->photo) }}" class="glightbox">
                        <div class="position-relative">
                            <img src="{{ asset($item->photo) }}" class="rounded overflow-hidden w-100 object-fit-cover" height="150px" alt="...">
                            <div class="small text-muted bg-body-tertiary position-absolute bottom-0 end-0 px-1 mb-1 me-1 rounded">({{ $item->size }})</div>
                        </div>
                    </a>
                    <div class="small text-muted text-truncate my-1">{{ $item->photo }}</div>
                    <div class="d-flex justify-content-end align-items-center">
                        <a class="btn btn-sm btn-default btn-outline-secondary ms-1" title="Download file" href="{{ asset($item->photo) }}" download="{{ $item->photo }}" target="_blank">
                           <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                                <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5"/>
                                <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708z"/>
                            </svg>
                        </a>
                        <button type="button" wire:click="delete({{ $item->id }})" class="btn btn-sm btn-default btn-outline-secondary ms-1" title="Remove file" data-url="https://imperialsuites.com.qa/admin/deleteGallery" data-key="15">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                            </svg>
                        </button>
                    </div>
                </div>
                @endforeach
                @endif
            </div>
            @if(count($photos)>0)
            {{-- Temporary photos --}}
            <div class="row row-cols-2 row-cols-sm-3 row-cols-lg-5 row-cols-lg-7 g-3 g-lg-3 mt-3">
                @foreach($photos as $index => $photo)
                <div class="col text-center rounded border p-2">
                    <a href="{{ $photo->temporaryUrl() }}" class="glightbox">
                        <div class="position-relative">
                            <img src="{{ $photo->temporaryUrl() }}" class="rounded overflow-hidden object-fit-cover" height="150px" alt="...">
                        </div>
                    </a>
                    <div class="d-flex justify-content-end align-items-center">
                        <button type="button" wire:click="removePhoto({{ $index }})" class="btn btn-sm btn-default btn-outline-secondary ms-1" title="Remove file" data-url="https://imperialsuites.com.qa/admin/deleteGallery" data-key="15">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                            </svg>
                        </button>
                    </div>
                </div>
                @endforeach
            </div>
            @endif
            <form wire:submit="save" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                <div class="input-group mt-3">
                    <x-input-floating model=".defer" type="file" name="photos" :messages="$errors->get('photos')" multiple />
                    <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                        <span wire:loading wire:target="save" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                        {{ __('Upload') }}
                    </button>
                </div>
        </div>
        <div class="position-relative w-100 border-top">       
            {{$collection->onEachSide(1)->links('components.layouts.pagination')}}
        </div>
    <!-- Confirm Modal Modal -->
    @include('components.layouts.confirm-modal')
    </div>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
@script
    <script>
        $wire.on('showModal', (event) => {
            setTimeout(function () {
                const modal = new bootstrap.Modal(document.getElementById(event[0].modal));
                modal.show();
            },0);
        });
        $wire.on('hideModal', (event) => {
            setTimeout(function () {
                const modalElement = document.getElementById(event[0].modal);
                const modal = bootstrap.Modal.getInstance(modalElement);
                modal.hide();
                Livewire.dispatch(event[0].modal);
            },0);
        });
    </script>
@endscript



