<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Database Backups <small class="fs-6">List</small></h5>
            </div>
            <div class="col text-end">
                @canany(['delete_backup','delete_all'])
                <button type="submit" class="btn btn-danger text-nowrap" wire:click="clean" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                        <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                        <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                      </svg>
                      <span wire:loading wire:target="clean" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                     Clean Backups
                </button>
                @endcanany
                @canany(['create_backup','create_all'])
                <button type="submit" class="btn btn-success text-nowrap" wire:click="create" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2"/>
                    </svg>
                    <span wire:loading wire:target="create" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                    Create Backup
                </button>
                @endcanany
            </div>
          </div>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <form action="{{ route('backup') }}" method="GET" accept-charset="UTF-8" class="d-none">
                        <div class="row row-cols-1 row-cols-lg-4 g-3 g-lg-3">
                            <div class="col-12 col-sm-6 col-md-3">
                                <div class="btn-group w-100">
                                    <a href="{{ route('backup') }}" class="btn btn-warning w-50 me-1" style="margin-top:1px;" page="button">Clear</a>
                                    <button type="button" class="btn btn-primary w-50 ms-1" id="filter-button" onclick="filterForm(this);" style="margin-top:1px;">Apply</button>
                                </div>
                            </div>
                        </div>
                    </form>
                <div class="shadow-sm rounded-bottom position-relative w-100">
                    <div class="table-responsive rounded">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="ps-4">ID</th>
                                    <th>Name</th>
                                    <th>Path</th>
                                    <th>Date</th>
                                    <th>File Size</th>
                                    <th>Download</th>
                                    @canany(['delete_backup','delete_all'])
                                    <th>Action</th>
                                    @endcanany
                                </tr>
                            </thead>
                            @if(count($collection) > 0)
                            <tbody>
                                @foreach($collection as $k => $file)
                                <tr>
                                    <td class="ps-4">{{ $loop->iteration }}</td>
                                    <td>{{ $file['name'] }}</td>
                                    <td>{{ $file['path'] }}</td>
                                    <td>{{ date('d M y h:i a', $file['last_modified']) }}</td>
                                    <td>{{ \App\Helpers\Helper::formatFileSize($file['size']) }}</td>
                                    <td><button class="btn btn-sm btn-primary" wire:click="download('{{ urlencode($file['name'])}}')"><i class="bi bi-cloud-arrow-down"></i> Download</button></td>
                                    @canany(['delete_backup','delete_all'])
                                    <td>
                                        <a href="javascript:void(0);" wire:click="delete('{{ urlencode($file['name'])}}')" data-button-type="delete" class="text-danger" data-bs-toggle="modal" data-bs-target="#confirmToast" data-bs-tooltip="tooltip" data-bs-placement="top" data-bs-custom-class="tooltip-danger" data-bs-title="Delete Record">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                            </svg>
                                        </a>
                                    </td>
                                    @endcanany
                                </tr>
                                @endforeach
                            </tbody>
                            @else
                            <tfoot>
                                <tr>
                                    <th class="text-center" colspan="7">No database backup found</th>
                                </tr>
                            </tfoot>
                            @endif
                        </table>
                    </div>
                    {{$collection->onEachSide(1)->links('components.layouts.pagination')}}
                </div>
            </div>
        </div>
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>
