<div>
    @if($createModal)
    <div class="modal fade" id="createModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form wire:submit="logoutOtherBrowserSessions" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    <div class="modal-header">
                        <div class="modal-title fs-6">Log Out Other Browser Sessions</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('createModal')"></button>
                    </div>
                    <div class="modal-body mx-md-4">
                       <div class="small text-muted mb-3">{{ __('Please enter your password to confirm you would like to log out of your other browser sessions across all of your devices.')}}
                        </div>
                        <x-input-floating type="password" name="password" :messages="$errors->get('password')"/>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <div>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('createModal')">Close</button>
                            <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="logoutOtherBrowserSessions" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                {{ __('Log Out Other Browser Sessions') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>
