

<div>
    <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 d-flex flex-column align-items-center justify-content-center">
                    <div class="d-flex justify-content-center py-4">
                        <a href="{{ route('login') }}" wire:navigate class="logo d-flex align-items-center w-auto">
                            <img src="{{ asset(Request::get('settings')[3]->value) }}" alt="..." />
                            <span class="d-none d-lg-block ms-2">Welcome To {{ Request::get('settings')[0]->value }}</span>
                        </a>
                    </div>
                    <!-- End Logo -->
                    <div class="card border border-light-subtle shadow-sm">
                        <div class="card-body p-5">
                            @if(Session::has('message'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ Session::get('message') }} 
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                              @endif
                            <div class="mb-3">
                                <div class="card-title text-center pb-0 fs-5">{{ __('Login to your account') }}</div>
                                <div class="small text-muted text-center">{{ __('Enter your email & password to login') }}</div>
                            </div>
                            <form wire:submit="login" class="needs-validation" novalidate>
                                <div  class="row row-cols-1 row-cols-lg-1 g-3 g-lg-3">
                                    <div class="col">
                                        <x-input-floating type="email" name="email" :messages="$errors->get('email')"/>
                                    </div>
                                    <div class="col">
                                        <x-input-floating type="password" name="password" :messages="$errors->get('password')"/>
                                    </div>
                                    <div class="col">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="form-check">
                                                <x-input-floating type="checkbox" name="remember" :messages="$errors->get('remember')" value="true" label="Remember Me" />
                                            </div>
                                            <a href="{{ route('password.request') }}" wire:navigate class="align-middle" wire:navigate>Forgot password?</a>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <button type="submit"  class="btn btn-primary w-100 mb-2" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                            <span wire:loading wire:target="login" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                            Login
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-3">Designed by <a href="https://www.smart-tech.com" target="_blank">Smart Tech</a></div>
            </div>
        </div>
    </section>
    
</div>
