function fullscreen(){
        if (document.fullscreenElement) {
            exitFullscreen();
        } else {
            launchFullscreen(document.body)
        }
    }
    function launchFullscreen(element) {
        if(element.requestFullscreen) {
            element.requestFullscreen();
        } else if(element.mozRequestFullScreen) {
            element.mozRequestFullScreen();
        } else if(element.msRequestFullscreen){
            element.msRequestFullscreen();
        } else if(element.webkitRequestFullscreen) {
            element.webkitRequestFullScreen();
        }
    }
    function exitFullscreen() {
        if (document.exitFullscreen) {
            document.exitFullscreen();
        } else if (document.msExitFullscreen) {
            document.msExitFullscreen();
        } else if (document.mozCancelFullScreen) {
            document.mozCancelFullScreen();
        } else if (document.webkitExitFullscreen) {
            document.webkitExitFullscreen();
        }
    }
ids = [];
function selectAll(){
    var checkboxs = document.querySelectorAll('.grid-row-checkbox');
    checkboxs.forEach((element) => {
        if(element.checked === true){
            element.checked = false;
            ids = [];  
        }else{
            element.value
            ids.push(element.value);
            element.checked = true;  
        }   
    });
    var selected = ids.length;
   if (selected > 0) {
    document.querySelector('.grid-select-all-btn').classList.remove('d-none');
   } else {
    document.querySelector('.grid-select-all-btn').classList.add('d-none');
   }
   document.querySelector('.selected').innerHTML = selected+" selected";
   // Find the Alpine component (using x-ref)
   const c = document.querySelector('[data-bs-target="#confirmModal"]');
   c.setAttribute("x-on:click", 'deleteId=['+ids+']');
}
function rowCheckbox(checkbox){
    var id = checkbox.value;
    if (checkbox.checked === true) {
        ids.push(id);
    } else {
        checkbox.checked = false;
        ids.splice(Array.prototype.indexOf(id, ids),1);
    }
    var selected = ids.length;
    if (selected > 0) {
        document.querySelector('.grid-select-all-btn').classList.remove('d-none');
    } else {
        document.querySelector('.grid-select-all-btn').classList.add('d-none');
    }
    document.querySelector('.selected').innerHTML = selected+" selected";
    // Find the Alpine component (using x-ref)
    const c = document.querySelector('[data-bs-target="#confirmModal"]');
    c.setAttribute("x-on:click", 'deleteId=['+ids+']');
}
/**
 * Initialize TinyMCE editor on a given selector and dispatch content on blur
 * @param {string} selector - The CSS selector for the textarea
 * @param {string} eventName - The Livewire event name to emit with the content
 */
const initTinyMCE = (selector, eventName) => {
   if (typeof tinymce === 'undefined') {
    console.warn('TinyMCE not loaded.');
    return;
  }
  // Remove editors on matching selectors
  tinymce.remove(selector);
  // Initialize TinyMCE on each matching textarea
  document.querySelectorAll(selector).forEach((editorElement) => {
    tinymce.init({
    target: editorElement,
                height: window.innerHeight-295, // Subtract some space for padding or margins
                plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
                editimage_cors_hosts: ['picsum.photos'],
                menubar: true,
                toolbar: 'undo redo bold italic underline alignleft aligncenter alignright alignjustify numlist bullist fullscreen preview print pagebreak image outdent indent fontfamily blocks forecolor backcolor removeformat charmap emoticons insertfile media template link anchor codesample ltr rtl',
                toolbar_sticky: true,
                toolbar_sticky_offset: 0,
                autosave_ask_before_unload: true,
                autosave_interval: '30s',
                autosave_prefix: '{path}{query}-{id}-',
                autosave_restore_when_empty: false,
                autosave_retention: '2m',
                quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                noneditable_class: 'mceNonEditable',
                toolbar_mode: 'sliding',
                skin: (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'oxide-dark' : 'oxide'),
                content_css: (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'default'),
                image_caption: true,
                image_advtab: true,
                file_picker_types: 'image',
                paste_data_images: false,
                importcss_append: true,
                images_upload_base_path: window.location.origin,
                file_picker_callback: (callback, value, meta) => {
                    /* Provide file and text for the link dialog */
                    if (meta.filetype === 'file') {
                        const url = prompt('Enter the URL of the file:');
                        if (url) {
                            callback(url, { title: 'File' });
                        }
                    }
                    /* Provide image and alt text for the image dialog */
                    if (meta.filetype === 'image') {
                        const url = prompt('Enter the URL of the image:');
                        if (url) {
                            callback(url, { title: 'Image' });
                        }
                    }
                    /* Provide alternative source and posted for the media dialog */
                    if (meta.filetype === 'media') {
                        const url = prompt('Enter the URL of the media:');
                        if (url) {
                            callback(url, { title: 'Media' });
                        }
                    }
                },
                font_family_formats: `
                        Aptos=aptos, sans-serif;
                        Arial=arial,helvetica,sans-serif;
                        Arial Black='Arial Black',sans-serif;
                        Comic Sans MS='Comic Sans MS',cursive,sans-serif;
                        Courier New='Courier New',courier,monospace;
                        Georgia=georgia,palatino,serif;
                        Tahoma=tahoma,arial,helvetica,sans-serif;
                        Times New Roman='Times New Roman',times,serif;
                        Trebuchet MS='Trebuchet MS',helvetica,sans-serif;
                        Verdana=verdana,geneva,sans-serif;
                        Calibri=calibri,Segoe,sans-serif;
                        Cambria=cambria,serif;
                        Candara=candara,calibri,sans-serif;
                        Consolas=consolas,monospace;
                        Franklin Gothic='Franklin Gothic Medium',sans-serif;
                        Garamond=garamond,serif;
                        Impact=impact,haettenschweiler,sans-serif;
                        Lucida Console='Lucida Console',monospace;
                        Lucida Sans='Lucida Sans',sans-serif;
                        Palatino Linotype='Palatino Linotype',serif;
                        Segoe UI='Segoe UI',sans-serif;
                        Segoe Print='Segoe Print',sans-serif;
                        Segoe Script='Segoe Script',sans-serif;
                        Courier=courier,monospace;
                        Baskerville=baskerville,serif;
                        Brush Script MT='Brush Script MT',cursive;
                        Rockwell=rockwell,serif;
                        Bodoni=Bodoni,serif;
                        Book Antiqua='Book Antiqua',serif;
                        Calisto MT='Calisto MT',serif;
                        Century=century,serif;
                        Century Gothic='Century Gothic',sans-serif;
                        Consolas=consolas,monospace;
                        Corbel=corbel,sans-serif;
                        Didot=didot,serif;
                        Ebrima=ebrima,sans-serif;
                        Gabriola=gabriola,serif;
                        Gothic=batang,gothic,sans-serif;
                        Helvetica=helvetica,sans-serif;
                        Hoefler='Hoefler Text',serif;
                        Lucida Bright='Lucida Bright',serif;
                        Menlo=menlo,monospace;
                        MS Gothic='MS Gothic',sans-serif;
                        MS Sans Serif='MS Sans Serif',sans-serif;
                        Palatino=palatino,serif;
                        Perpetua=perpetua,serif;
                        Rockwell=rockwell,serif;
                        Stencil=stencil,sans-serif;
                        Tisa=tisa,serif;
                        Verdana=verdana,sans-serif;
                        Webdings=webdings,sans-serif;
                        Wingdings=wingdings,sans-serif;
                        Roboto=roboto,sans-serif;
                        Open Sans='Open Sans',sans-serif;
                        Lato=lato,sans-serif;
                        Oswald=oswald,sans-serif;
                    `,
                
                // All your init stuff here, then the super important part at the bottom
                setup: function (editor) {
                    editor.on('init change', function () {
                        editor.save();
                    });
                    // Emit Livewire event with editor content on blur
                    editor.on('blur', function () {
                        let langId = document.getElementById(editor.id).dataset.lang;
                        if (langId) {
                                Livewire.dispatch(eventName, {
                                langId: langId,
                                content: editor.getContent(),
                            });
                        }
                    });
                },
            });
});
}
