<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Module;
use App\Models\Role;
use App\Models\Permission;
use App\Models\Setting;
use App\Models\Language;

use Illuminate\Support\Facades\Hash;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create modules
        $modules = [
            ['name' => 'All'],
            ['name' => 'User'],
            ['name' => 'Role'],
            ['name' => 'Permission'],
            ['name' => 'Backup'],
            ['name' => 'Activity Log'],
            ['name' => 'Login History'],
            ['name' => 'General Settings'],
            ['name' => 'Social Settings'],
            ['name' => 'Alert Settings'],
            ['name' => 'Language Settings'],
            ['name' => 'Page'],
        ];
        foreach ($modules as $moduleName) {
            $module = Module::create($moduleName);
            // Create Permissions for each module
            $permissions = [
                'view',
                'create',
                'update',
                'delete',
                'status',
            ];
            foreach ($permissions as $action) {
                Permission::create([
                    'module_id'     =>  $module->id,
                    'name'          =>  strtolower("{$action}_{$module->name}"),
                    'description'   =>  "{$action} all modules"
                ]);
            }
        }
        // Create roles and assign permissions
        $role_admin = Role::create(['name' => 'Administrator', 'description' => 'Administrator']);
        Role::create(['name' => 'User', 'description' => 'User']);
        Role::create(['name' => 'Sub Admin', 'description' => 'Sub Admin']);

        // Assign all permissions to Admin Role
        $role_admin->permissions()->sync(Permission::pluck('id')->toArray());
        $roles = ['Administrator', 'Sub Admin', 'User'];

        $batchSize = 30;
        $iterations = 10;
        $admin = User::create(['name' =>'Admin', 'email' => 'admin@gmail.com', 'password' => Hash::make('11111111'), 'email_verified_at' => date('Y-m-d h:i:s')]);
        $admin->roles()->sync(Role::whereIn('name', $roles)->pluck('id')->toArray());
        $admin->permissions()->sync(Permission::pluck('id')->toArray());
        for ($i = 0; $i < $iterations; $i++) {
            // Now create users using the factory
            User::factory()->count($batchSize)->create()->each(function ($user) use ($roles) {
                // Assign random roles to each user (you can adjust this logic as needed)
                $user->roles()->sync(Role::whereIn('name', $roles)->pluck('id')->toArray());
                $user->permissions()->sync(Permission::pluck('id')->toArray());
            });
        }
        
        $settings = [
            ['name'      => 'app_name', 'value' =>  'Laravel'],
            ['name'      => 'url', 'value' =>  'http://localhost/'],
            ['name'      => 'site_logo', 'value' =>  'https://laravel.com/img/logomark.min.svg'],
            ['name'      => 'app_logo', 'value' =>  'https://laravel.com/img/logomark.min.svg'],

            ['name'      => 'primary_email', 'value' =>  'info@example.com'],
            ['name'      => 'other_email', 'value' =>  'sales@example.com'],

            ['name'      => 'primary_phone', 'value' =>  '+974 00000000'],
            ['name'      => 'other_phone', 'value' =>  '+974 11111111'],

            ['name'      => 'building', 'value' =>  '00'],
            ['name'      => 'street', 'value' =>  '000'],
            ['name'      => 'city', 'value' =>  'City Name'],
            ['name'      => 'state', 'value' =>  'State Name'],
            ['name'      => 'postal_code', 'value' =>  '00000'],
            ['name'      => 'country', 'value' =>  'Country NAme'],
            ['name'      => 'address', 'value' =>  'Write your complete address here'],

            ['name'      => 'latitude', 'value' =>  '25.434343433543'],
            ['name'      => 'longitude', 'value' =>  '51.5r242242342'],
            ['name'      => 'embed_map', 'value' =>  'https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d225.47571098164414!2d51.5425654656934!3d25.28365541764154!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e45c56c42c727b1%3A0x18b31a1f2afa4c64!2z2LTZgtmCINin2YXYqNix2YrYp9mE!5e0!3m2!1sen!2sqa!4v1701174216670!5m2!1sen!2sqa'],
           
            ['name'      => 'login_with_email', 'value' =>  '1'],
            ['name'      => 'login_with_phone', 'value' =>  '1'],
            ['name'      => 'login_with_username', 'value' =>  '1'],

            ['name'      => 'google_login', 'value' =>  '0'],
            ['name'      => 'google_app_id', 'value' =>  NULL],
            ['name'      => 'google_secret_id', 'value' =>  NULL],
            ['name'      => 'google_callback_url', 'value' =>  '#'],

            ['name'      => 'facebook_login', 'value' =>  '0'],
            ['name'      => 'facebook_app_id', 'value' =>  NULL],
            ['name'      => 'facebook_secret_id', 'value' => NULL],
            ['name'      => 'facebook_callback_url', 'value' =>  '#'],

            ['name'      => 'apple_login', 'value' =>  '0'],
            ['name'      => 'apple_app_id', 'value' =>  NULL],
            ['name'      => 'apple_secret_id', 'value' =>  NULL],
            ['name'      => 'apple_callback_url', 'value' =>  '#'],
            
            ['name'      => 'facebook_url', 'value' =>  'https://www.facebook.com'],
            ['name'      => 'instagram_url', 'value' =>  'https://www.instagram.com'],
            ['name'      => 'linkedin_url', 'value' =>  'https://www.linkedin.com'],
            ['name'      => 'twitter_url', 'value' =>  'https://www.twitter.com'],
            ['name'      => 'tiktok_url', 'value' =>  'https://www.tiktok.com'],
            ['name'      => 'youtube_url', 'value' =>  'https://www.youtube.com'],
            ['name'      => 'snapchat_url', 'value' =>  'https://www.snapchat.com'],

            ['name'      => 'onesignal_push', 'value' =>  '0'],
            ['name'      => 'onesignal_app_id', 'value' =>  NULL],
            ['name'      => 'onesignal_secret_id', 'value' =>  NULL],

            ['name'      => 'firebase_push', 'value' =>  '0'],
            ['name'      => 'firebase_secret_id', 'value' => NULL],
            
            ['name'      => '_token', 'value' =>  'LIlpa3egh3rKMDMEgxOGL5Q0IlnHboU1TewvXGVc'],
        ];
        DB::table('settings')->insert($settings);
        DB::table('settings')->update(['created_at'  =>    date('Y-m-d h:i:s'),'updated_at'  =>    date('Y-m-d h:i:s')]);
        Language::insert([
            [   'name'      =>  'English', 
                'locale'    =>  'en',
                'code'      =>  'en_US', 
                'flag'      =>  '',
                'direction' =>  'ltr', 
                'status'    =>  'Active',
                'is_default'=>  'Yes'
            ],
            [   'name'      =>  'Arabic', 
                'locale'    =>  'ar',
                'code'      =>  'ar_US', 
                'flag'      =>  '',
                'direction' =>  'rtl', 
                'status'    =>  'Active',
                'is_default'=>  'No'
            ],
        ]);
        $this->command->info('DB seeded successfully.');
    }
}
