<?php

namespace App\Models;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserLoginHistory extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'user_login_histories';
    protected $fillable = [
        'notifiable_type',
        'user_id',	
        'city',	
        'country',	
        'country_code',	
        'region',	
        'region_code',	
        'timezone',	
        'postal_code',	
        'latitude',	
        'longitude',	
        'ip',	
        'device',
        'session_id',
    ];
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class)->withDefault();
    }
    public function maintainer(): BelongsTo
    {
        return $this->belongsTo(Maintainer::class)->withDefault();
    }
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class)->withDefault();
    }
}
