<?php

namespace App\Models;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Language extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'languages';
    protected $fillable = ['name','locale','code','flag','direction','status','is_default'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }

    public static function enabledCodes(): array
    {
        return self::where('status', true)->pluck('code')->toArray();
    }

    public static function rtlLocales(): array
    {
        return self::where('status', true)->where('direction', 'rtl')->pluck('code')->toArray();
    }
}