<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AwardTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'award_translations';
    protected $fillable = ['award_id', 'language_id', 'name', 'review'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    
    public function award(): BelongsTo
    {
        return $this->belongsTo(Award::class);
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class);
    }
}