<?php

namespace App\Livewire\Web;

use App\Models\Page;
use App\Models\Room;
use App\Models\Offer;
use App\Models\Award;
use App\Models\Service;
use App\Models\Testimonial;
use App\Models\Gallery;
use App\Models\Place;
use App\Models\Feedback;

use Livewire\Component;

class WelcomeComponent extends Component
{
    public function render()
    {
        $pageTitle = "Book Directly & Get Exclusive Rates";
        $metaDescription = "Discover luxury and comfort at Imperial Suites Doha, your premier destination for unforgettable stays. Explore our beautifully designed rooms, exquisite dining options, and top-notch amenities. Whether you're traveling for business or leisure, Imperial Suites ensures a memorable experience. Book your stay today and indulge in world-class hospitality and personalized service in the heart of Doha Qatar.";

        $rooms = Room::with('photos')->whereStatus('Active')->get();
        $galleries = Gallery::take(5)->inRandomOrder()->get();
        $testimonials = Testimonial::all();
        $services = Service::take(6)->get();
        return view('web.welcome-component',compact('pageTitle','metaDescription','rooms','galleries','testimonials','services'))->layout('web.layouts.app');
    }
}
