<?php

namespace App\Livewire\Web;
use App\Models\Room;
use App\Models\Service;
use Livewire\Component;

class RoomDetailComponent extends Component
{
    public $slug;
    public function render()
    {
        $room = Room::with('photos')->whereSlug($this->slug)->whereStatus('Active')->first();
        if($room){
            $pageTitle = $room->translation()->name;
            return view('web.room',compact('pageTitle','room'))->layout('web.layouts.app');
        }else{
            return $this->redirect('/rooms',navigate:true);
        }
    }
}