<?php

namespace App\Livewire\Traits;

use Livewire\Component;

trait AuthorizesRequests
{
    /**
     * Authorizes the request. Handles both unauthorized responses and redirects.
     *
     * @return mixed|null Returns the response if unauthorized, or null if authorized (GET request).
     */
    protected function authorizeAndRedirect()
    {
        if (request()->isMethod('POST') || request()->ajax() || request()->wantsJson()) {
            return $this->dispatch('response', ['type' => 'error', 'message' => 'You are unauthorized to this action!']);
        } else {
            $this->redirect('/dashboard', navigate: true); // Redirect on successful GET request
        }
        return null; // Important: Return null to indicate authorization success
    }
}