<?php

namespace App\Livewire\Auth;

use Livewire\Component;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Auth\Events\PasswordReset;

class ResetPasswordComponent extends Component
{
    public $token;
    public $email;
    public $password;
    public $password_confirmation;

    protected $rules = [
        'password' => 'required|min:8|confirmed',
        'password_confirmation' => 'required',
    ];

    public function mount($token, $email)
    {
        $this->token = $token;
        $this->email = $email;
    }

    public function resetPassword()
    {
        $this->validate();

        $response = Password::reset([
                'email'     => $this->email,
                'password'  => $this->password,
                'password_confirmation' => $this->password_confirmation,
                'token'     => $this->token,
            ],
            function ($user) {
                $user->forceFill([
                    'password' => Hash::make($this->password),
                    'remember_token' => Str::random(60),
                ])->save();
                event(new PasswordReset($user));
            }
        );
        $response == Password::PASSWORD_RESET
        ? $this->sendResetResponse($response)
        : $this->sendResetFailedResponse($response);
    }
    protected function sendResetResponse($response)
    {
        $this->redirectRoute('dashboard', navigate: true);
        $this->dispatch('response', ['type' => 'success', 'message' => trans($response)]);
        
    }
    protected function sendResetFailedResponse($response)
    {
        $this->dispatch('response', ['type' => 'danger', 'message' => trans($response)]);
    }
    public function render()
    {
        return view('admin.auth.reset-password')->layout('components.layouts.guest');
    }
}
