<?php

namespace App\Livewire\Auth;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
class LogoutComponent extends Component
{
    public function logout()
    {
        $this->guard()->logout();
        session()->invalidate();
        session()->regenerateToken();
        $this->redirect('/login', navigate: true);
    }
    protected function guard()
    {
        return Auth::guard();
    }

    public function render()
    {
        return view('admin.auth.logout');
    }
}
