<?php

namespace App\Livewire\Auth;
use App\Helpers\Helper;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Validator;

class Login2FAComponent extends Component
{

    public $code, $recovery_code;
    // Login method with 2fa
    public function verify2FACode()
    {
        $this->validate([
            'code'     =>  'required|string|max:50',
        ]);
        
        if (Auth::check()) {
            if(auth()->user()->verifyCode($this->code,null)){
                return $this->redirect('/dashboard',navigate:true); // Redirect after successful login
            }
        }else{
            $this->dispatch('logout');
            return $this->redirect('/login',navigate:true); // Redirect after successful login
        }
    }
    public function verify2FARecoveryCode()
    {
        $this->validate([
            'recovery_code'    =>  'required|string|max:50',
        ]);
        if (Auth::check()) {
            if(auth()->user()->verifyCode(null, $this->recovery_code)){
                return $this->redirect('/dashboard',navigate:true); // Redirect after successful login
            }
        }else{
            $this->dispatch('logout');
            return $this->redirect('/login',navigate:true); // Redirect after successful login
        }
    }

    public function logout()
    {
        $this->guard()->logout();
        session()->invalidate();
        session()->regenerateToken();
        $this->redirectRoute('login', navigate: true);
    }

    protected function guard()
    {
        return Auth::guard();
    }
    // Render method for the Livewire view
    public function render()
    {
        return view('admin.auth.verify-2fa')->layout('components.layouts.guest');
    }
}
