<?php

namespace App\Livewire\Auth;

use Livewire\Component;
use Illuminate\Support\Facades\Password;

class ForgotPasswordComponent extends Component
{
    public $email;

    protected $rules = [
        'email' => 'required|email|exists:users,email',
    ];

    public function sendResetLink()
    {
        $this->validate();

        $response = Password::sendResetLink(['email' => $this->email]);

        if ($response == Password::RESET_LINK_SENT) {
            $this->dispatch('response', ['type' => 'success', 'message' => 'We have sent a password reset link to your email address.']);
        } else {
            $this->dispatch('response', ['type' => 'danger', 'message' => 'Failed to send reset link.!']);
        }
    }

    public function render()
    {
        return view('admin.auth.forgot-password')->layout('components.layouts.guest');
    }
}
