<?php

namespace App\Livewire\Admin;

use App\Models\Setting;
use App\Helpers\Helper;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

use Livewire\Component;
use Livewire\WithFileUploads;

use App\Livewire\Traits\AuthorizesRequests;

class GeneralSettingsComponent extends Component
{
    use WithFileUploads,AuthorizesRequests;
    public $app_name,$url, $site_logo, $app_logo, $primary_email, $other_email, $primary_phone, $other_phone, 
    $building, $street, $city, $state, $postal_code, $country, $address, $latitude, $longitude, $embed_map;
    public function mount(){
        $settings = Setting::all();
        $this->app_name         = $settings[0]->value;
        $this->url              = $settings[1]->value;
        $this->primary_email    = $settings[4]->value;
        $this->other_email      = $settings[5]->value;
        $this->primary_phone    = $settings[6]->value;
        $this->other_phone      = $settings[7]->value;
        $this->building         = $settings[8]->value;
        $this->street           = $settings[9]->value;
        $this->city             = $settings[10]->value;
        $this->state            = $settings[11]->value;
        $this->postal_code      = $settings[12]->value;
        $this->country          = $settings[13]->value;
        $this->address          = $settings[14]->value;
        $this->latitude         = $settings[15]->value;
        $this->longitude        = $settings[16]->value;
        $this->embed_map        = $settings[17]->value;
    }
    public function render()
    {
        if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        return view('admin.settings.general-settings-component');
    }
    
    public function update(){
		if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        $data = $this->validate([
            'app_name'           =>  'required|string|max:50',
            'url'                =>  'required|string|max:255',
            'site_logo'          =>  'nullable|mimes:jpeg,png,jpg,webp|max:5120',
            'app_logo'           =>  'nullable|mimes:jpeg,png,jpg,webp|max:5120',
            'primary_email'      =>  'required|string|max:50|email',
            'primary_email'      =>  'required|string|max:50|email',
            'primary_phone'      =>  'string|max:50',
            'other_phone'        =>  'string|max:50',
            'building'           =>  'required|string|max:25',
            'street'             =>  'required|string|max:25',
            'city'               =>  'required|string|max:25',
            'state'              =>  'string|max:25',
            'postal_code'        =>  'string|max:10',
            'country'            =>  'required|string|max:25',
            'address'            =>  'required|string|max:100',
            'latitude'           =>  'string|max:25',
            'longitude'          =>  'string|max:25',
            'embed_map'          =>  'string|max:300',
          ]);
          foreach($data as $key => $value){
			//website logo
			if($key == 'site_logo'){
			    if($this->site_logo && $this->site_logo->isValid()){
					Helper::deleteFile($value);
                    $value = Helper::saveFile('site',$this->site_logo,$w=null,$h=null);
                }else{
                    $key = '';
                }
                $this->reset('site_logo');
			}
			//favicon logo
			if($key=='app_logo'){
				if($this->app_logo && $this->app_logo->isValid()){
					Helper::deleteFile($value);
                    $value = Helper::saveFile('site',$this->app_logo,$w=200,$h=200);
				}else{
                    $key = '';
                }
                $this->reset('app_logo');
			}
			$checkExist = Setting::whereName($key)->first();
			if($checkExist){
				$checkExist->update(['value'=>addslashes($value)]);
			}
		}
        $this->dispatch('app_name', app_name: $this->app_name);
        $this->dispatch('response', ['type' => 'success', 'message' => 'General Settings has been updated successfully!']);
    }
    public function link(){
        if (!Gate::allows('update_generalsettings') && !Gate::allows('update_all')) {
			return $this->authorizeAndRedirect();
		}
        if (is_link(public_path('storage'))) {
            unlink(public_path('storage'));
        }
        Artisan::call('storage:link');
        $this->dispatch('response', ['type' => 'success', 'message' => 'Application files has been linked succesfully']);
    }
   
    public function setProductionMode()
    {
        $data = ['APP_ENV' => 'production', 'APP_DEBUG' => 'false'];
        $this->setEnvValues($data);
        if (file_exists($cachedConfigPath = base_path('bootstrap/cache/config.php'))) {
            unlink($cachedConfigPath);
        }
        if (file_exists($cachedConfigPath = base_path('bootstrap/cache/events.php'))) {
            unlink($cachedConfigPath);
        }
        if (file_exists($cachedConfigPath = base_path('bootstrap/cache/routes-v7.php'))) {
            unlink($cachedConfigPath);
        }
        $this->cacheEvents();
        $this->cacheRoutes();
        $this->cacheConfig();
        $this->dispatch('response', ['type' => 'success', 'message' => 'Application is now running in production mode.!']);
        return $this->redirect('/general-settings');
    }
    public function cacheEvents()
    {   
        Artisan::call('event:cache');
    }
    public function cacheRoutes()
    {   
        Artisan::call('route:cache');
    }
    public function cacheConfig()
    {   
        Artisan::call('config:cache');
    }
    public function development(){
        if (!Gate::allows('update_generalsettings') && !Gate::allows('update_all')) {
			return $this->authorizeAndRedirect();
		}
        // Set the application to local (development) mode
        $data = ['APP_ENV' => 'local', 'APP_DEBUG' => 'true'];
        $this->clearConfig();
        $this->clearEvents();
        $this->clearRoutesCache();
        $this->setEnvValues($data);
        $this->dispatch('response', ['type' => 'warning', 'message' => 'Application now running in development mode']);
    }
    
    public function clearConfig()
    {
        if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        Artisan::call('config:clear');
        $this->dispatch('response', ['type' => 'success', 'message' => 'Config cache has been cleared successfully!']);
    }
    public function clearEvents()
    {   if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
        }
        Artisan::call('event:clear');
        $this->dispatch('response', ['type' => 'success', 'message' => 'Events cache has been cleared successfully!']);
    }
    public function clearRoutesCache()
    {
        if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        Artisan::call('route:clear');
        $this->dispatch('response', ['type' => 'success', 'message' => 'Routes Cache has been cleared successfully!']);
    }

    public function clearCompiledViews()
    {
        if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        Artisan::call('view:clear');
        $this->dispatch('response', ['type' => 'success', 'message' => 'Compiled views has been cleared successfully!']);
    }

    public function clearLogs()
    {
        if (!Gate::allows('view_generalsettings') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        $logsPath = storage_path('logs');
        $files = File::files($logsPath);
        foreach ($files as $file) {
            File::delete($file);
        }
        $this->dispatch('response', ['type' => 'success', 'message' => 'Logs has been cleared successfully!']);
    }
    
    private function setEnvValues(array $values)
    {
        $envFile = base_path('.env');

        if (file_exists($envFile)) {
            $envContent = file_get_contents($envFile);

            foreach ($values as $key => $value) {
                $pattern = "/^{$key}=.*/m";

                if (preg_match($pattern, $envContent)) {
                    $envContent = preg_replace($pattern, "{$key}=\"{$value}\"", $envContent);
                } else {
                    $envContent .= "\n{$key}=\"{$value}\"";
                }
            }
            file_put_contents($envFile, $envContent);
        }
    }
}
