<?php

namespace App\Livewire\Admin;
use App\Models\Gallery;
use App\Helpers\Helper;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;

use Livewire\Component;
use Livewire\WithPagination;
use Livewire\WithFileUploads;
use App\Livewire\Traits\AuthorizesRequests;

class GalleryComponent extends Component
{
    use WithPagination, WithFileUploads, AuthorizesRequests;
    public $perPage = 10;

    public $gallery;
    public $photos = [];

    public function save()
    {
        $this->validate([
                    'photos'             =>  'required|array',
                    'photos.*'           =>  'mimes:jpeg,png,jpg,webp|max:5120',
                ]);
                // Save photos
                foreach ($this->photos as $photo) {
                    $path = Helper::saveFile('galleries',$photo);
                    Gallery::create(['photo' => $path]);
                }
                $this->photos = [];
                $this->dispatch('response', ['type'    => 'success','message' => 'Photo has been inserted successfully!']);
    }
    public function removePhoto($index)
    {
        unset($this->photos[$index]);
        $this->photos = array_values($this->photos);
    }
    public function delete($id){
        if (!Gate::allows('delete_gallery') && !Gate::allows('delete_all')) {
            return $this->authorizeAndRedirect();
        }
        $photo = Gallery::whereId($id)->first();
        if ($photo) {
            Helper::deleteFile($photo->photo);
            $photo->delete();
        }
        $this->dispatch('response', ['type' => 'success', 'message' => 'Photos has been deleted successfully!']);
    }
    public function render()
    {
        if (!Gate::allows('view_gallery') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
        }
        $query = Gallery::query();

        $collection = $query->paginate($this->perPage);
        if($collection->count()){
            foreach($collection as $gallery){
                $size =  Helper::getFileSize($gallery->photo);
                $gallery->size = Helper::formatFileSize((int)$size);
                $gallery->type = Helper::getFileType($gallery->photo);
            }
        }
        return view('admin.gallery.index',compact('collection'));
    }
}