<?php

namespace App\Livewire\Admin;
use App\Models\Feedback;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Gate;

use Livewire\Component;
use Livewire\WithPagination;
use App\Livewire\Traits\AuthorizesRequests;

class FeedbackComponent extends Component
{
    use WithPagination, AuthorizesRequests;
    public $search = '';
    public $perPage = 10;
    public $feedback;

    public function delete($ids)
    {
        if (!Gate::allows('delete_feedback') && !Gate::allows('delete_all')) {
            return $this->authorizeAndRedirect();
        }
        $collection = Feedback::find($ids);
        if($collection->count()){
            foreach($collection as $item){
                $item->delete();
            }
        } 
        $this->dispatch('response', ['type' => 'success', 'message' => 'Feedback has been deleted successfully!']);
        $this->dispatch('hideModal',['modal'=>'confirmModal']);
    }

    public function render()
    {
        if (!Gate::allows('view_feedback') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
        }
        $query = Feedback::query();
        if($this->search){
            $query->where('rating','like', '%'.$this->search.'%')
            ->orWhere('subject','like', '%'.$this->search.'%')
            ->orWhere('message','like', '%'.$this->search.'%')
            ->orWhere('page','like', '%'.$this->search.'%');
        }
        $collection = $query->paginate($this->perPage);
        return view('admin.feedbacks.index',compact('collection'));
    }

}