<?php

namespace App\Livewire\Admin;

use App\Models\Setting;
use App\Helpers\Helper;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Artisan;

use Livewire\Component;
use App\Livewire\Traits\AuthorizesRequests;

class AlertSettingsComponent extends Component
{
    use AuthorizesRequests;
    public 
    $pusher_app_id, 
    $pusher_app_key, 
    $pusher_app_secret, 
    $pusher_host, 
    $pusher_port, 
    $pusher_scheme, 
    $pusher_app_cluster,

    $mail_mailer, 
    $mail_host, 
    $mail_port, 
    $mail_username, 
    $mail_password,
    $mail_encryption,
    $mail_from_address,

    $aws_access_key_id,
    $aws_secret_access_key,
    $aws_default_region,
    $aws_bucket,

    $onesignal_push,
    $onesignal_app_id,
    $onesignal_secret_id,

    $firebase_push,
    $firebase_secret_id;

    public function mount(){
        $settings = Setting::all();

        // Load existing values from env
        $this->pusher_app_id        =   env('PUSHER_APP_ID');
        $this->pusher_app_key       =   env('PUSHER_APP_KEY');
        $this->pusher_app_secret    =   env('PUSHER_APP_SECRET');
        $this->pusher_host          =   env('PUSHER_HOST');
        $this->pusher_port          =   env('PUSHER_PORT');
        $this->pusher_scheme        =   env('PUSHER_SCHEME');
        $this->pusher_app_cluster   =   env('PUSHER_APP_CLUSTER');

        $this->mail_mailer          =   env('MAIL_MAILER');
        $this->mail_host            =   env('MAIL_HOST');
        $this->mail_port            =   env('MAIL_PORT');
        $this->mail_username        =   env('MAIL_USERNAME');
        $this->mail_password        =   env('MAIL_PASSWORD');
        $this->mail_encryption      =   env('MAIL_ENCRYPTION');
        $this->mail_from_address    =   env('MAIL_FROM_ADDRESS');


        $this->aws_access_key_id    =   env('AWS_ACCESS_KEY_ID');
        $this->aws_secret_access_key=   env('AWS_SECRET_ACCESS_KEY');
        $this->aws_default_region   =   env('AWS_DEFAULT_REGION');
        $this->aws_bucket           =   env('AWS_BUCKET');

        // Load existing push from settings
        $this->onesignal_push       = $settings[40]->value;
        $this->onesignal_app_id     = $settings[41]->value;
        $this->onesignal_secret_id  = $settings[42]->value;

        $this->firebase_push        = $settings[43]->value;
        $this->firebase_secret_id   = $settings[44]->value;
    }
    public function render()
    {
        if (!Gate::allows('view_alertsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        return view('admin.settings.alert-settings-component');
    }
    public function pushOnesignalFirebase(){
		if (!Gate::allows('view_alertsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        $data = $this->validate([
            'onesignal_push'         =>  'required|numeric|in:0,1',
            'onesignal_app_id'       =>  'nullable|string|max:255',
            'onesignal_secret_id'    =>  'nullable|max:255',

            'firebase_push'         =>  'required|numeric|in:0,1',
            'firebase_secret_id'    =>  'nullable|max:255'
        ]);
        foreach($data as $key => $value){
            $checkExist = Setting::whereName($key)->first();
			if($checkExist){
				$checkExist->update(['value'=>addslashes($value)]);
			}
        }
        return $this->dispatch('response', ['type' => 'success', 'message' => 'Push notification settings has been updated successfully!']);
	}
    public function updateEnv()
    {
        if (!Gate::allows('view_alertsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        $data = [
            'PUSHER_APP_ID'         =>  $this->pusher_app_id,
            'PUSHER_APP_KEY'        =>  $this->pusher_app_key,
            'PUSHER_APP_SECRET'     =>  $this->pusher_app_secret,
            'PUSHER_HOST'           =>  $this->pusher_host,
            'PUSHER_PORT'           =>  $this->pusher_port,
            'PUSHER_SCHEME'         =>  $this->pusher_scheme,
            'PUSHER_APP_CLUSTER'    =>  $this->pusher_app_cluster,

            'MAIL_MAILER'           =>  $this->mail_mailer,
            'MAIL_HOST'             =>  $this->mail_host,
            'MAIL_PORT'             =>  $this->mail_port,
            'MAIL_USERNAME'         =>  $this->mail_username,
            'MAIL_PASSWORD'         =>  $this->mail_password,
            'MAIL_ENCRYPTION'       =>  $this->mail_encryption,
            'MAIL_FROM_ADDRESS'     =>  $this->mail_from_address,

            'AWS_ACCESS_KEY_ID'     =>  $this->aws_access_key_id,
            'AWS_SECRET_ACCESS_KEY' =>  $this->aws_secret_access_key,
            'AWS_DEFAULT_REGION'    =>  $this->aws_default_region,
            'AWS_BUCKET'            =>  $this->aws_bucket,
        ];

        $this->setEnvValues($data);
        Artisan::call('config:clear');
        return $this->dispatch('response', ['type' => 'success', 'message' => 'Environment variables updated successfully!']);
    }
    private function setEnvValues(array $values)
    {
        $envFile = base_path('.env');

        if (file_exists($envFile)) {
            $envContent = file_get_contents($envFile);

            foreach ($values as $key => $value) {
                $pattern = "/^{$key}=.*/m";

                if (preg_match($pattern, $envContent)) {
                    $envContent = preg_replace($pattern, "{$key}=\"{$value}\"", $envContent);
                } else {
                    $envContent .= "\n{$key}=\"{$value}\"";
                }
            }
            file_put_contents($envFile, $envContent);
        }
    }
}
