<?php
namespace App\Http\Controllers\App\V1;
use App\Models\User;
use App\Models\UserLoginHistory;
use App\Helpers\Helper;
use App\Models\Notification as UserNotification;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

use Laravel\Passport\TokenRepository;
use Laravel\Passport\RefreshTokenRepository;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Password;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Notification;
use App\Notifications\ForgotPasswordNotification;
use MakiDizajnerica\GeoLocation\Facades\GeoLocation;
use Illuminate\Support\Str;
use DB;

class UserController extends Controller
{
    public function updateAccount(Request $request){
        $data = $this->validate($request, [
            'name'          =>  'required|string|alpha_spaces|max:50',
            'phone'         =>  'required|numeric|unique:users,phone,'.request()->user()->id,
            'gender'        =>  'required|in:Male,Female',
            'date_of_birth' =>  'required|date|date_format:Y-m-d',
            'image'         =>  'mimes:jpeg,png,jpg,webp|max:10240'
          ]);
          
        if($request->hasfile('image')){
            Helper::deleteFile(request()->user()->image);
            $data['image'] = Helper::saveFile('users',$request->file('image'),$w=200,$h=200);
        }
        request()->user()->update($data);
        return  response()->json([
            'data'      =>  User::find(request()->user()->id),
            'message'   =>  'Your account has been updated successfully!','status'=>'success'
        ],200);
    }
    public function deleteAccount(Request $request){
   	    User::whereId(request()->user()->id)->delete();
		return  response()->json([
            'message' => 'Account deleted successfully','status'=>'success'
        ],200);
	}
}