<?php
namespace App\Http\Controllers\App\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
public function notifications(Request $request){
        $notifications = request()->user()->notifications()->orderBy('created_at','DESC')->paginate(10);
        return  response()->json([
            'data' =>  $notifications,
            'unread'        =>  request()->user()->unreadNotifications()->count(),
            
        ],200);
    }
    public function readAll(Request $request){
		request()->user()->unreadNotifications->markAsRead();
		return  response()->json([
            'message' => 'All unread notifications marked as read.','status'=>'success'
        ],200);
	}
    public function markAsRead($id){
  	    $unreadNotification = request()->user()->unreadNotifications->where('id',$id)->first();
        if($unreadNotification) {
            $unreadNotification->markAsRead();
        }
	}
}