<?php

namespace App\Http\Controllers\App\V1\Auth;

use App\Models\User;
use App\Http\Controllers\Controller;
use App\Notifications\EmailVerificationNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use DB;

class VerificationController extends Controller
{
    public function resendEmailVerificationCode(Request $request){ 
        $user = User::whereEmail(request()->user()->email)->first();
        if(!empty($user)){
            $hours = intval(intval((strtotime(date('Y-m-d H:i:s')) - strtotime($user->verification_code_sent_at))/60)/60);
            if($user->verification_code_sent >= 3 && $hours == 0){
                return  response()->json([
                    'message' => 'You sent code many times. Please try again after one hour','status' =>'warning'
                ],200);
            }else{
                $user->update([
                    'verification_code'         =>  random_int(1000,9999),
                    'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                    'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                ]);
                Notification::send($user, new EmailVerificationNotification($user));
                return  response()->json([
                    'message' => 'Verification code has been sent your email address!','status' =>'success'
                ],200);
            }
        }else{
            return  response()->json([
                'message' => 'This email does not belong to us!','status' =>'danger'
            ],200);
        }
    }
    public function verifyEmail(Request $request){
        $this->validate($request, [
            'verification_code' => 'required|numeric|exists:users,verification_code', 
        ],[
            'verification_code.required' => 'The verification code is required.',
            'verification_code.numeric' => 'The verification code must be a number.',
            'verification_code.exists' => 'The verification code is invalid.',
        ]);
        request()->user()->update([
            'email_verified_at'         => date('Y-m-d H:i:s'),
            'verification_code'         => NULL,
            'verification_code_sent'    => 0,
            'verification_code_sent_at' => NULL,
        ]);
        return  response()->json([
            'message' => 'Your Email has been verified successfully!','status'=>'success'
        ],200);
    }
    public function resendPhoneVerificationCode(Request $request){ 
        $this->validate($request, [
            'phone' => 'required|numeric|exists:users,phone',
        ]);
        $user = User::wherePhone($request->phone)->first();
            if(!empty($user)){
                $hours = intval(intval((strtotime(date('Y-m-d H:i:s')) - strtotime($user->verification_code_sent_at))/60)/60);
                if($user->verification_code_sent >= 3 && $hours == 0){
                    return  response()->json([
                        'message' => 'You sent code many times. Please try again after one hour','status' =>'warning'
                    ],200);
                }else{
                    $phone = $user->phone;
                    $response = json_decode(Http::get('http://api.smsala.com/api/Verify?api_id=API859895216394&api_password=Bunyansms123@&brand=Kolshay&phonenumber='.$phone.'&sender_id=KOLSHAY'));
                    if($response->status == 'S'){
                        $user->update([
                            'verification_code'   =>  $response->verfication_id ?? null,
                            'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                            'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                        ]);
                        $message = 'Verification code has been sent to your phone';
                    }else if($response->status == 'F'){
                        $message = 'Something Went Wrong!';
                    }else{
                        $message = 'Something Went Wrong!';
                    }
                    $user->update([
                        'verification_code'         =>  random_int(1000,9999),
                        'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                        'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                    ]);
                    return  response()->json([
                        'message' => 'Verification code has been sent your phone!','status' =>'success'
                    ],200);
                }
            }
    }
    public function verifyPhone(Request $request){
        $this->validate($request, [
            'verification_code' => 'required|numeric|exists:users,verification_code', 
        ],[
            'verification_code.required' => 'The verification code is required.',
            'verification_code.numeric' => 'The verification code must be a number.',
            'verification_code.exists' => 'The verification code is invalid.',
        ]);
        request()->user()->update([
            'phone_verified_at'         => date('Y-m-d H:i:s'),
            'verification_code'         => NULL,
            'verification_code_sent'    => 0,
            'verification_code_sent_at' => NULL,
        ]);
        return  response()->json([
            'message' => 'Your Phone has been verified successfully!','status'=>'success'
        ],200);
    }
}