<?php

namespace App\Http\Controllers\App\V1\Auth;

use App\Models\User;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Notifications\EmailVerificationNotification;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use DB;

class RegisterController extends Controller
{
    public function register(Request $request){
        
        $data = $this->validate($request, [
            'name'          =>  ['required','string','max:50','regex:/^[a-zA-Z0-9 ]*$/'],
            'email'         =>  'required|string|email|max:50|unique:users',
            'phone'         =>  'nullable|numeric|unique:users',
            'password'      =>  'required|string|min:6|confirmed',
        ]);
        $data['password'] = Hash::make($request->password);
        if($request->hasfile('image')){
            $data['image']  = Helper::saveFile('users',$request->image,$w=200, $h=200);
    	}else{
            $image = Helper::saveDefaultImage('users');
        }
        $user = User::create($data);
        $this->sendCode($user);
        $token = $user->createToken('api-token')->plainTextToken;
        Helper::userLoginHistory('App\Models\User',$user->id,$request->headers->all());
        $user = User::whereEmail($request->email)->first();
        return  response()->json([
            'data'      =>  $user,
            'token'     =>  $token,
            'message'   =>  'Registered successully!','status'=>'success'
        ],200);
    }
    public function sendCode($user){
        if(!empty($user)){
            $user->update([
                'verification_code'         =>  random_int(1000,9999),
                'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                'verification_code_sent_at' =>  date('Y-m-d H:i:s')
            ]);
            $user = User::whereEmail($user->email)->first();
            try {
                Notification::send($user, new EmailVerificationNotification($user));
                return  response()->json([
                    'message' => 'Verification Code has been sent your email address!'
                ],200);
            } catch (\Exception $e) {
                \Log::emergency("Mail Error, File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
            }
        }
    }
}