<?php

namespace App\Http\Controllers\App\V1\Auth;

use App\Models\User;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    public function login(Request $request){
        
        $this->validate($request, [
            'email_or_phone'=>  'required|string',
            'password'      =>  'required|string',
        ]);
        $key = 'email';
        if(is_numeric($request->email_or_phone)){
            $key = 'phone';
            $user = User::wherePhone($request->email_or_phone)->first();
        }else if (filter_var($request->email_or_phone, FILTER_VALIDATE_EMAIL)) {
            $user = User::whereEmail($request->email_or_phone)->first();
        }else{
            return response()->json([
                'message' => 'This email or phone does not match our records.','status'=>'danger'
            ],422);
        }

        if(!empty($user) && $user == 'InActive'){
            return  response()->json([
                'message' => 'Your account has been deactivated! kindly contact with '.request()->get('settings')[0]->value,'status'=>'danger'
            ],403);
        }
        if(auth()->guard()->attempt([$key => $request->email_or_phone, 'password' => $request->password])){
            $token = $user->createToken('api-token')->plainTextToken;
            Helper::userLoginHistory('App\Models\User', $user->id, $request->headers->all());
            return  response()->json([
                'data'      =>  $user,
                'token'     =>  $token,
                'message'   =>  'Logged in Successfully!',
                'status'    =>  'success'
            ],200);
        }else{
            return  response()->json([
                'message' => 'These credentials do not match our records.','status'=>'danger'
            ],401);
        }
    }

    public function logout(){
        request()->user()->tokens()->where('id', request()->user()->currentAccessToken()->id)->delete();
        return  response()->json([
            'message' => 'Your are logged out successully!','status'=>'success'
        ],200);
    }
}
