<?php

namespace App\Http\Controllers\App\V1\Auth;

use App\Models\User;
use App\Http\Controllers\Controller;
use App\Notifications\ForgotPasswordNotification;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use DB;

class ForgotPasswordController extends Controller
{
    public function forgotPassword(Request $request){ 
        $this->validate($request, [
            'email_or_phone'=>  'required|string',
        ]);
        if(is_numeric($request->email_or_phone)){
            $user = User::wherePhone($request->email_or_phone)->first();
            if(!empty($user->phone)){
                $hours = intval(intval((strtotime(date('Y-m-d H:i:s')) - strtotime($user->verification_code_sent_at))/60)/60);
                if($user->verification_code_sent >= 5 && $hours == 0){
                    return  response()->json([
                        'message' => 'You sent code many times. Please try again after one hour','status' =>'warning'
                    ],429);
                }else{
                    // $phone = $user->phone;
                    // $response = json_decode(Http::get('http://api.smsala.com/api/Verify?api_id=API859895216394&api_password=Bunyansms123@&brand=Kolshay&phonenumber='.$phone.'&sender_id=KOLSHAY'));
                    // if($response->status == 'S'){
                    //     $user->update([
                    //         'phone_verification_code'   =>  $response->verfication_id ?? null,
                    //         'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                    //         'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                    //     ]);
                    //     $message = 'Verification code has been sent to your phone';
                    // }else if($response->status == 'F'){
                    //     $message = 'Something Went Wrong!';
                    // }else{
                    //     $message = 'Something Went Wrong!';
                    // }
                    $user->update([
                        'verification_code'         =>  random_int(1000,9999),
                        'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                        'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                    ]);
                    // Notification::send($user, new ForgotPasswordNotification($user));
                    return  response()->json([
                        'message' => 'Reset code has been sent your phone!','status' =>'success'
                    ],200);
                }
            }else{
                return  response()->json([
                    'message' => 'Phone number does not belong to us!','status' =>'danger'
                ],200);
            }
        }elseif (filter_var($request->email_or_phone, FILTER_VALIDATE_EMAIL)) {
            $user = User::whereEmail($request->email_or_phone)->first();
            if(!empty($user)){
                $hours = intval(intval((strtotime(date('Y-m-d H:i:s')) - strtotime($user->verification_code_sent_at))/60)/60);
                if($user->verification_code_sent >= 5 && $hours == 0){
                    return  response()->json([
                        'message' => 'You sent code many times. Please try again after one hour','status' =>'warning'
                    ],200);
                }else{
                    $user->update([
                        'verification_code'=>random_int(1000,9999),
                        'verification_code_sent'    =>  DB::raw('verification_code_sent+1'),
                        'verification_code_sent_at' =>  date('Y-m-d H:i:s')
                    ]);
                    Notification::send($user, new ForgotPasswordNotification($user));
                    return  response()->json([
                        'message' => 'Reset code has been sent your email address!','status' =>'success'
                    ],200);
                }
            }else{
                return  response()->json([
                    'message' => 'This email does not belong to us!','status' =>'danger'
                ],200);
            }
        }else{
            return  response()->json([
                'message' => 'This phone or email do not match our records.','status' =>'danger'
            ],200);
        }    
    }

    public function resetPassword(Request $request){
        
        $this->validate($request, [
            'verification_code' => 'required|numeric', 
            'new_password' => 'required|string|min:6', 
        ]);
        $user = User::whereVerificationCode($request->verification_code)->first();
        if(!empty($user)){
            $user->update([
                'verification_code'         => NULL,
                'verification_code_sent'    => 0,
                'verification_code_sent_at' => NULL,
                'password'                  => Hash::make($request->new_password),
            ]);
            return  response()->json([
                'message' => 'Your Password has been updated successfully!','status'=>'success'
            ],200);
        }else{
            return  response()->json([
                'message' => 'Verification code is invalid!','status'=>'danger'
            ],200);
        }
    }
    public function updatePassword(Request $request){
        
        $this->validate($request, [
            'old_password' => 'required|string|min:6', 
            'new_password' => 'required|string|min:6', 
        ]);
        if (Hash::check($request->old_password, request()->user()->password)) { 
            request()->user()->fill([
                'password' => Hash::make($request->new_password)
            ])->save();
            return  response()->json([
                'message' => 'Your Password has been updated successfully!','status'=>'success'
            ],200);
        }else{
            return  response()->json([
                'message' => 'Old Password does not match!','status'=>'danger'
            ],200);
        }
    }
}