<?php
namespace App\Helpers;

use App\Models\UserLoginHistory;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use MakiDizajnerica\GeoLocation\Facades\GeoLocation;
use Carbon\Carbon;
use Jenssegers\Agent\Agent;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class Helper
{
    public static function userLoginHistory($type = null, $user_id = null, $headers = null, $session = null){
        
        $collection = GeoLocation::lookup(request()->ip());
        UserLoginHistory::create([
            'notifiable_type'=> $type,
            'user_id'       => $user_id,
            'country'       => $collection['country'],
            'city'          => $collection['city'],
            'country_code'  => $collection['countryCode'],
            'region'        => $collection['region'],
            'region_code'   => null,
            'timezone'      => $collection['timezone'],
            'postal_code'   => null,
            'latitude'      => $collection['latitude'],
            'longitude'     => $collection['longitude'],
            'ip'            => $collection['ip'],
            'device'        => self::createAgent() ?? 'Unknown',
            'session_id'    => $session,
        ]);
    }
    public static function createAgent(){
        $agent = new Agent();
        if($agent->isDesktop()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isMobile()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isTablet()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isPhone()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isRobot()){
            $device = $agent->device().$agent->robot().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isAndroidOS()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isNexus()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }elseif($agent->isSafari()){
            $device = $agent->device().', '.$agent->platform().', '.$agent->browser();
        }else{
            $device = 'Unknown';
        }
        return $device;
    }
    
    public static function saveDefaultImage($dir_name,$gender = null){
        $path = storage_path('app/public/'.$dir_name.'/'.date('Y').'/'.date('m').'/');
        if(!File::exists($path)){
            File::makeDirectory($path, 0755, true, true);
        }
        $oldPath = '';
        if($gender == 'Male' && Storage::disk('public')->exists('defaults/male.webp')){
            $oldPath = public_path('storage/defaults/male.webp');
        }elseif($gender == 'Female' && Storage::disk('public')->exists('defaults/female.webp')){
            $oldPath = public_path('storage/defaults/female.webp');
        }elseif(Storage::disk('public')->exists('defaults/user.webp')){
            $oldPath = public_path('storage/defaults/user.webp');
        }else{
            return $oldPath;
        }
        if($oldPath){
            $fileExtension = \File::extension($oldPath);
            $fileName = time().random_int(10, 999).'.'.$fileExtension;
            $newPathWithName = $path.$fileName;
            File::copy($oldPath , $newPathWithName);
            return 'storage/'.$dir_name.'/'.date('Y').'/'.date('m').'/'.$fileName;
        }
    }

    public static function saveFile($dir_name,$file,$w=NULL,$h=NULL){
        try{
            $path = storage_path('app/public/'.$dir_name.'/'.date('Y').'/'.date('m').'/');
            if(!File::exists($path)){
                File::makeDirectory($path, 0755, true, true);
            }
            $manager = new ImageManager(new Driver());
            if($file->getClientOriginalExtension() == 'png' || $file->getClientOriginalExtension() == 'PNG' || $file->getClientOriginalExtension() == 'jpeg' || $file->getClientOriginalExtension() == 'JPEG' || $file->getClientOriginalExtension() == 'JPG' || $file->getClientOriginalExtension() == 'jpg' || $file->getClientOriginalExtension() == 'webp' || $file->getClientOriginalExtension() == 'WEBP'){
                $fileName = time().random_int(10, 999).'.webp';
                $file = $manager->read($file);
                if($w != NULL && $h != NULL){
                    $file->resize($w, $h);
                }
                $encoded = $file->toWebp(90);
                $encoded->save($path.$fileName);
            }else{
                $fileName = time().random_int(10, 999).'.'.$file->getClientOriginalExtension();
                $encoded = $file->encode(new AutoEncoder(quality: 90));
                $encoded->move($path,$fileName);
            }
            return 'storage/'.$dir_name.'/'.date('Y').'/'.date('m').'/'.$fileName;
        } catch (\Exception $e) {
            \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
            $output = array('message' => $e->getMessage().' Something went wrong!','type' => 'error');
        }
        return $output;
    }

    public static function deleteFile($file){
        File::delete(public_path($file));
    }
    public static function getFileType($file){
        if(empty(File::exists(public_path($file)))){
            return  'image';
        }else{
            $type = \File::extension(public_path($file));
            if($type == 'jpeg' || $type == 'png' || $type == 'jpg' || $type == 'webp'){
                return 'image';
            }else{
                return  'pdf';
            }
        }
    }
    public static function getFileSize($file){
        if(empty(File::exists(public_path($file)))){
            return 0;
        }else{
            return  \File::size(public_path($file))/1024;
        }
    }
    public static function formatFileSize($bytes, $decimals = 2)
    {
        $size = ['B', 'KB', 'MB', 'GB', 'TB'];
        if ($bytes == 0) {
            return '0 B';
        }
        $factor = floor((strlen((string) $bytes) - 1) / 3);
        $factor = min($factor, count($size) - 1); // prevent overflow
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . ' ' . $size[$factor];
    }
    
    //Get the first letter of each word in a string
    public static function getInitials(string|null $string) {
        return array_reduce(
            explode(' ', $string),
            function ($initials, $word) {
                return sprintf('%s%s', $initials, substr($word, 0, 1));
            },
            ''
        );
    }
    public static function getMonthListFromDate(Carbon $start, Carbon $end){
        $start = $start->startOfMonth();
        $end   = $end->startOfMonth();
        do{
            $months[] = $start->format('Y-m-d');
        } while ($start->addMonth() <= $end);
        return $months;
    }
}