<?php

namespace App\Console\Commands;

use App\Models\UserLoginHistory;
use App\Notifications\ScheduleErrorNotification;
use Illuminate\Support\Facades\Notification;
use Illuminate\Console\Command;

class DeleteUserLoginHistory extends Command
{
    protected $signature = 'dulh:run';
    protected $description = "Command to delete user's login histories before three months";
    public function handle()
    {
        try{
             UserLoginHistory::whereDate('created_at','<=',date('Y-m-d', strtotime('-3 month')))->delete();
        } catch (Exception $e) {
            $output = array('Exception' => 'File:' .$e->getFile(). 'Line:' .$e->getLine(). 'message' .$e->getMessage(),'type' => 'error');
            Notification::route('mail', request()->get('settings')[4]->value)->notify(new  ScheduleErrorNotification($output));
        }
    }
}