<?php

namespace App\Console\Commands;

use App\Models\ActivityLog;
use App\Notifications\ScheduleErrorNotification;
use Illuminate\Support\Facades\Notification;
use Illuminate\Console\Command;

class DeleteUserActivityLogs extends Command
{
    protected $signature = 'dual:run';
    protected $description = "Command to delete user's activities logs before three months";
    public function handle()
    {
        try{
             ActivityLog::whereDate('created_at','<=',date('Y-m-d', strtotime('-6 month')))->delete();
        } catch (Exception $e) {
            $output = array('Exception' => 'File:' .$e->getFile(). 'Line:' .$e->getLine(). 'message' .$e->getMessage(),'type' => 'error');
            Notification::route('mail', request()->get('settings')[4]->value)->notify(new  ScheduleErrorNotification($output));
        }
    }
}