<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use File;

class CleanAllBackup extends Command
{
    protected $signature = 'backup:cleanall';
    protected $description = 'Delete all backup files';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $backupPath = storage_path('app/backups');
        // Ensure the backup directory exists
        if (File::exists($backupPath)) {
            File::cleanDirectory($backupPath); // Delete all files and subdirectories
            $this->info('All backup files have been deleted.');
        } else {
            $this->error('Backup directory does not exist.');
        }
    }
}
